package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetWebhookResponse(webhook: zio.aws.amplify.model.Webhook) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.GetWebhookResponse = {
    import GetWebhookResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.GetWebhookResponse
      .builder()
      .webhook(webhook.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.GetWebhookResponse.ReadOnly =
    zio.aws.amplify.model.GetWebhookResponse.wrap(buildAwsValue())
}
object GetWebhookResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.GetWebhookResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.GetWebhookResponse =
      zio.aws.amplify.model.GetWebhookResponse(webhook.asEditable)
    def webhook: zio.aws.amplify.model.Webhook.ReadOnly
    def getWebhook: ZIO[Any, Nothing, zio.aws.amplify.model.Webhook.ReadOnly] =
      ZIO.succeed(webhook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.GetWebhookResponse
  ) extends zio.aws.amplify.model.GetWebhookResponse.ReadOnly {
    override val webhook: zio.aws.amplify.model.Webhook.ReadOnly =
      zio.aws.amplify.model.Webhook.wrap(impl.webhook())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.GetWebhookResponse
  ): zio.aws.amplify.model.GetWebhookResponse.ReadOnly = new Wrapper(impl)
}
