package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Job(
    summary: zio.aws.amplify.model.JobSummary,
    steps: Iterable[zio.aws.amplify.model.Step]
) {
  def buildAwsValue(): software.amazon.awssdk.services.amplify.model.Job = {
    import Job.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.Job
      .builder()
      .summary(summary.buildAwsValue())
      .steps(steps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.Job.ReadOnly =
    zio.aws.amplify.model.Job.wrap(buildAwsValue())
}
object Job {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.amplify.model.Job] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.Job = zio.aws.amplify.model.Job(
      summary.asEditable,
      steps.map { item =>
        item.asEditable
      }
    )
    def summary: zio.aws.amplify.model.JobSummary.ReadOnly
    def steps: List[zio.aws.amplify.model.Step.ReadOnly]
    def getSummary
        : ZIO[Any, Nothing, zio.aws.amplify.model.JobSummary.ReadOnly] =
      ZIO.succeed(summary)
    def getSteps: ZIO[Any, Nothing, List[zio.aws.amplify.model.Step.ReadOnly]] =
      ZIO.succeed(steps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.Job
  ) extends zio.aws.amplify.model.Job.ReadOnly {
    override val summary: zio.aws.amplify.model.JobSummary.ReadOnly =
      zio.aws.amplify.model.JobSummary.wrap(impl.summary())
    override val steps: List[zio.aws.amplify.model.Step.ReadOnly] = impl
      .steps()
      .asScala
      .map { item =>
        zio.aws.amplify.model.Step.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.Job
  ): zio.aws.amplify.model.Job.ReadOnly = new Wrapper(impl)
}
