package zio.aws.amplify.model
import scala.jdk.CollectionConverters.*
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.amplify.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.amplify.model.JobStatus
  ): zio.aws.amplify.model.JobStatus = value match {
    case software.amazon.awssdk.services.amplify.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplify.model.JobStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.amplify.model.JobStatus.PROVISIONING =>
      val r = PROVISIONING
      r
    case software.amazon.awssdk.services.amplify.model.JobStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.amplify.model.JobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.amplify.model.JobStatus.SUCCEED =>
      val r = SUCCEED
      r
    case software.amazon.awssdk.services.amplify.model.JobStatus.CANCELLING =>
      val r = CANCELLING
      r
    case software.amazon.awssdk.services.amplify.model.JobStatus.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.amplify.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.JobStatus =
      software.amazon.awssdk.services.amplify.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.amplify.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.JobStatus =
      software.amazon.awssdk.services.amplify.model.JobStatus.PENDING
  }
  case object PROVISIONING extends zio.aws.amplify.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.JobStatus =
      software.amazon.awssdk.services.amplify.model.JobStatus.PROVISIONING
  }
  case object RUNNING extends zio.aws.amplify.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.JobStatus =
      software.amazon.awssdk.services.amplify.model.JobStatus.RUNNING
  }
  case object FAILED extends zio.aws.amplify.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.JobStatus =
      software.amazon.awssdk.services.amplify.model.JobStatus.FAILED
  }
  case object SUCCEED extends zio.aws.amplify.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.JobStatus =
      software.amazon.awssdk.services.amplify.model.JobStatus.SUCCEED
  }
  case object CANCELLING extends zio.aws.amplify.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.JobStatus =
      software.amazon.awssdk.services.amplify.model.JobStatus.CANCELLING
  }
  case object CANCELLED extends zio.aws.amplify.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.JobStatus =
      software.amazon.awssdk.services.amplify.model.JobStatus.CANCELLED
  }
}
