package zio.aws.amplify.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.amplify.model.primitives.{
  CommitId,
  JobArn,
  EndTime,
  StartTime,
  JobId,
  CommitTime,
  CommitMessage
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class JobSummary(
    jobArn: JobArn,
    jobId: JobId,
    commitId: CommitId,
    commitMessage: CommitMessage,
    commitTime: CommitTime,
    startTime: StartTime,
    status: zio.aws.amplify.model.JobStatus,
    endTime: Optional[EndTime] = Optional.Absent,
    jobType: zio.aws.amplify.model.JobType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.JobSummary = {
    import JobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.JobSummary
      .builder()
      .jobArn(JobArn.unwrap(jobArn): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .commitId(CommitId.unwrap(commitId): java.lang.String)
      .commitMessage(CommitMessage.unwrap(commitMessage): java.lang.String)
      .commitTime(CommitTime.unwrap(commitTime): Instant)
      .startTime(StartTime.unwrap(startTime): Instant)
      .status(status.unwrap)
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .jobType(jobType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.JobSummary.ReadOnly =
    zio.aws.amplify.model.JobSummary.wrap(buildAwsValue())
}
object JobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.JobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.JobSummary =
      zio.aws.amplify.model.JobSummary(
        jobArn,
        jobId,
        commitId,
        commitMessage,
        commitTime,
        startTime,
        status,
        endTime.map(value => value),
        jobType
      )
    def jobArn: JobArn
    def jobId: JobId
    def commitId: CommitId
    def commitMessage: CommitMessage
    def commitTime: CommitTime
    def startTime: StartTime
    def status: zio.aws.amplify.model.JobStatus
    def endTime: Optional[EndTime]
    def jobType: zio.aws.amplify.model.JobType
    def getJobArn: ZIO[Any, Nothing, JobArn] = ZIO.succeed(jobArn)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getCommitId: ZIO[Any, Nothing, CommitId] = ZIO.succeed(commitId)
    def getCommitMessage: ZIO[Any, Nothing, CommitMessage] =
      ZIO.succeed(commitMessage)
    def getCommitTime: ZIO[Any, Nothing, CommitTime] = ZIO.succeed(commitTime)
    def getStartTime: ZIO[Any, Nothing, StartTime] = ZIO.succeed(startTime)
    def getStatus: ZIO[Any, Nothing, zio.aws.amplify.model.JobStatus] =
      ZIO.succeed(status)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getJobType: ZIO[Any, Nothing, zio.aws.amplify.model.JobType] =
      ZIO.succeed(jobType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.JobSummary
  ) extends zio.aws.amplify.model.JobSummary.ReadOnly {
    override val jobArn: JobArn =
      zio.aws.amplify.model.primitives.JobArn(impl.jobArn())
    override val jobId: JobId =
      zio.aws.amplify.model.primitives.JobId(impl.jobId())
    override val commitId: CommitId =
      zio.aws.amplify.model.primitives.CommitId(impl.commitId())
    override val commitMessage: CommitMessage =
      zio.aws.amplify.model.primitives.CommitMessage(impl.commitMessage())
    override val commitTime: CommitTime =
      zio.aws.amplify.model.primitives.CommitTime(impl.commitTime())
    override val startTime: StartTime =
      zio.aws.amplify.model.primitives.StartTime(impl.startTime())
    override val status: zio.aws.amplify.model.JobStatus =
      zio.aws.amplify.model.JobStatus.wrap(impl.status())
    override val endTime: Optional[EndTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.amplify.model.primitives.EndTime(value))
    override val jobType: zio.aws.amplify.model.JobType =
      zio.aws.amplify.model.JobType.wrap(impl.jobType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.JobSummary
  ): zio.aws.amplify.model.JobSummary.ReadOnly = new Wrapper(impl)
}
