package zio.aws.amplify.model
import zio.prelude.data.Optional
import zio.aws.amplify.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAppsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListAppsRequest = {
    import ListAppsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListAppsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.ListAppsRequest.ReadOnly =
    zio.aws.amplify.model.ListAppsRequest.wrap(buildAwsValue())
}
object ListAppsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListAppsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListAppsRequest =
      zio.aws.amplify.model.ListAppsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListAppsRequest
  ) extends zio.aws.amplify.model.ListAppsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.amplify.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.amplify.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListAppsRequest
  ): zio.aws.amplify.model.ListAppsRequest.ReadOnly = new Wrapper(impl)
}
