package zio.aws.amplify.model
import zio.prelude.data.Optional
import zio.aws.amplify.model.primitives.{
  NextToken,
  MaxResults,
  JobId,
  AppId,
  BranchName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListArtifactsRequest(
    appId: AppId,
    branchName: BranchName,
    jobId: JobId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListArtifactsRequest = {
    import ListArtifactsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListArtifactsRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.ListArtifactsRequest.ReadOnly =
    zio.aws.amplify.model.ListArtifactsRequest.wrap(buildAwsValue())
}
object ListArtifactsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListArtifactsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListArtifactsRequest =
      zio.aws.amplify.model.ListArtifactsRequest(
        appId,
        branchName,
        jobId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def appId: AppId
    def branchName: BranchName
    def jobId: JobId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListArtifactsRequest
  ) extends zio.aws.amplify.model.ListArtifactsRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
    override val jobId: JobId =
      zio.aws.amplify.model.primitives.JobId(impl.jobId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.amplify.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.amplify.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListArtifactsRequest
  ): zio.aws.amplify.model.ListArtifactsRequest.ReadOnly = new Wrapper(impl)
}
