package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDomainAssociationsResponse(
    domainAssociations: Iterable[zio.aws.amplify.model.DomainAssociation],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListDomainAssociationsResponse = {
    import ListDomainAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListDomainAssociationsResponse
      .builder()
      .domainAssociations(domainAssociations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.amplify.model.ListDomainAssociationsResponse.ReadOnly =
    zio.aws.amplify.model.ListDomainAssociationsResponse.wrap(buildAwsValue())
}
object ListDomainAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListDomainAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListDomainAssociationsResponse =
      zio.aws.amplify.model.ListDomainAssociationsResponse(
        domainAssociations.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def domainAssociations
        : List[zio.aws.amplify.model.DomainAssociation.ReadOnly]
    def nextToken: Optional[NextToken]
    def getDomainAssociations: ZIO[Any, Nothing, List[
      zio.aws.amplify.model.DomainAssociation.ReadOnly
    ]] = ZIO.succeed(domainAssociations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListDomainAssociationsResponse
  ) extends zio.aws.amplify.model.ListDomainAssociationsResponse.ReadOnly {
    override val domainAssociations
        : List[zio.aws.amplify.model.DomainAssociation.ReadOnly] = impl
      .domainAssociations()
      .asScala
      .map { item =>
        zio.aws.amplify.model.DomainAssociation.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.amplify.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListDomainAssociationsResponse
  ): zio.aws.amplify.model.ListDomainAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
