package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListJobsResponse(
    jobSummaries: Iterable[zio.aws.amplify.model.JobSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListJobsResponse = {
    import ListJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListJobsResponse
      .builder()
      .jobSummaries(jobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.ListJobsResponse.ReadOnly =
    zio.aws.amplify.model.ListJobsResponse.wrap(buildAwsValue())
}
object ListJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListJobsResponse =
      zio.aws.amplify.model.ListJobsResponse(
        jobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def jobSummaries: List[zio.aws.amplify.model.JobSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getJobSummaries
        : ZIO[Any, Nothing, List[zio.aws.amplify.model.JobSummary.ReadOnly]] =
      ZIO.succeed(jobSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListJobsResponse
  ) extends zio.aws.amplify.model.ListJobsResponse.ReadOnly {
    override val jobSummaries: List[zio.aws.amplify.model.JobSummary.ReadOnly] =
      impl
        .jobSummaries()
        .asScala
        .map { item =>
          zio.aws.amplify.model.JobSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.amplify.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListJobsResponse
  ): zio.aws.amplify.model.ListJobsResponse.ReadOnly = new Wrapper(impl)
}
