package zio.aws.amplify.model
import zio.prelude.data.Optional
import zio.aws.amplify.model.primitives.{MaxResults, NextToken, AppId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListWebhooksRequest(
    appId: AppId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListWebhooksRequest = {
    import ListWebhooksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListWebhooksRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.ListWebhooksRequest.ReadOnly =
    zio.aws.amplify.model.ListWebhooksRequest.wrap(buildAwsValue())
}
object ListWebhooksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListWebhooksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListWebhooksRequest =
      zio.aws.amplify.model.ListWebhooksRequest(
        appId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def appId: AppId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListWebhooksRequest
  ) extends zio.aws.amplify.model.ListWebhooksRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.amplify.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.amplify.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListWebhooksRequest
  ): zio.aws.amplify.model.ListWebhooksRequest.ReadOnly = new Wrapper(impl)
}
