package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartDeploymentResponse(
    jobSummary: zio.aws.amplify.model.JobSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.StartDeploymentResponse = {
    import StartDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.StartDeploymentResponse
      .builder()
      .jobSummary(jobSummary.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.StartDeploymentResponse.ReadOnly =
    zio.aws.amplify.model.StartDeploymentResponse.wrap(buildAwsValue())
}
object StartDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.StartDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.StartDeploymentResponse =
      zio.aws.amplify.model.StartDeploymentResponse(jobSummary.asEditable)
    def jobSummary: zio.aws.amplify.model.JobSummary.ReadOnly
    def getJobSummary
        : ZIO[Any, Nothing, zio.aws.amplify.model.JobSummary.ReadOnly] =
      ZIO.succeed(jobSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.StartDeploymentResponse
  ) extends zio.aws.amplify.model.StartDeploymentResponse.ReadOnly {
    override val jobSummary: zio.aws.amplify.model.JobSummary.ReadOnly =
      zio.aws.amplify.model.JobSummary.wrap(impl.jobSummary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.StartDeploymentResponse
  ): zio.aws.amplify.model.StartDeploymentResponse.ReadOnly = new Wrapper(impl)
}
