package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.{BranchName, DomainPrefix}
import scala.jdk.CollectionConverters.*
final case class SubDomainSetting(
    prefix: DomainPrefix,
    branchName: BranchName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.SubDomainSetting = {
    import SubDomainSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.SubDomainSetting
      .builder()
      .prefix(DomainPrefix.unwrap(prefix): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.SubDomainSetting.ReadOnly =
    zio.aws.amplify.model.SubDomainSetting.wrap(buildAwsValue())
}
object SubDomainSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.SubDomainSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.SubDomainSetting =
      zio.aws.amplify.model.SubDomainSetting(prefix, branchName)
    def prefix: DomainPrefix
    def branchName: BranchName
    def getPrefix: ZIO[Any, Nothing, DomainPrefix] = ZIO.succeed(prefix)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.SubDomainSetting
  ) extends zio.aws.amplify.model.SubDomainSetting.ReadOnly {
    override val prefix: DomainPrefix =
      zio.aws.amplify.model.primitives.DomainPrefix(impl.prefix())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.SubDomainSetting
  ): zio.aws.amplify.model.SubDomainSetting.ReadOnly = new Wrapper(impl)
}
