package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateAppResponse(app: zio.aws.amplify.model.App) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.UpdateAppResponse = {
    import UpdateAppResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.UpdateAppResponse
      .builder()
      .app(app.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.UpdateAppResponse.ReadOnly =
    zio.aws.amplify.model.UpdateAppResponse.wrap(buildAwsValue())
}
object UpdateAppResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.UpdateAppResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.UpdateAppResponse =
      zio.aws.amplify.model.UpdateAppResponse(app.asEditable)
    def app: zio.aws.amplify.model.App.ReadOnly
    def getApp: ZIO[Any, Nothing, zio.aws.amplify.model.App.ReadOnly] =
      ZIO.succeed(app)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.UpdateAppResponse
  ) extends zio.aws.amplify.model.UpdateAppResponse.ReadOnly {
    override val app: zio.aws.amplify.model.App.ReadOnly =
      zio.aws.amplify.model.App.wrap(impl.app())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.UpdateAppResponse
  ): zio.aws.amplify.model.UpdateAppResponse.ReadOnly = new Wrapper(impl)
}
