package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.{
  WebhookId,
  UpdateTime,
  WebhookArn,
  CreateTime,
  Description,
  WebhookUrl,
  BranchName
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Webhook(
    webhookArn: WebhookArn,
    webhookId: WebhookId,
    webhookUrl: WebhookUrl,
    branchName: BranchName,
    description: Description,
    createTime: CreateTime,
    updateTime: UpdateTime
) {
  def buildAwsValue(): software.amazon.awssdk.services.amplify.model.Webhook = {
    import Webhook.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.Webhook
      .builder()
      .webhookArn(WebhookArn.unwrap(webhookArn): java.lang.String)
      .webhookId(WebhookId.unwrap(webhookId): java.lang.String)
      .webhookUrl(WebhookUrl.unwrap(webhookUrl): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .description(Description.unwrap(description): java.lang.String)
      .createTime(CreateTime.unwrap(createTime): Instant)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.Webhook.ReadOnly =
    zio.aws.amplify.model.Webhook.wrap(buildAwsValue())
}
object Webhook {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.amplify.model.Webhook] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.Webhook =
      zio.aws.amplify.model.Webhook(
        webhookArn,
        webhookId,
        webhookUrl,
        branchName,
        description,
        createTime,
        updateTime
      )
    def webhookArn: WebhookArn
    def webhookId: WebhookId
    def webhookUrl: WebhookUrl
    def branchName: BranchName
    def description: Description
    def createTime: CreateTime
    def updateTime: UpdateTime
    def getWebhookArn: ZIO[Any, Nothing, WebhookArn] = ZIO.succeed(webhookArn)
    def getWebhookId: ZIO[Any, Nothing, WebhookId] = ZIO.succeed(webhookId)
    def getWebhookUrl: ZIO[Any, Nothing, WebhookUrl] = ZIO.succeed(webhookUrl)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getDescription: ZIO[Any, Nothing, Description] =
      ZIO.succeed(description)
    def getCreateTime: ZIO[Any, Nothing, CreateTime] = ZIO.succeed(createTime)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.Webhook
  ) extends zio.aws.amplify.model.Webhook.ReadOnly {
    override val webhookArn: WebhookArn =
      zio.aws.amplify.model.primitives.WebhookArn(impl.webhookArn())
    override val webhookId: WebhookId =
      zio.aws.amplify.model.primitives.WebhookId(impl.webhookId())
    override val webhookUrl: WebhookUrl =
      zio.aws.amplify.model.primitives.WebhookUrl(impl.webhookUrl())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
    override val description: Description =
      zio.aws.amplify.model.primitives.Description(impl.description())
    override val createTime: CreateTime =
      zio.aws.amplify.model.primitives.CreateTime(impl.createTime())
    override val updateTime: UpdateTime =
      zio.aws.amplify.model.primitives.UpdateTime(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.Webhook
  ): zio.aws.amplify.model.Webhook.ReadOnly = new Wrapper(impl)
}
