package zio.aws.amplify
import zio.prelude.Subtype
import zio.aws.amplify.model.primitives.{
  UploadUrl,
  ThumbnailName,
  TagValue,
  FileName,
  AssociatedResource,
  ThumbnailUrl,
  AutoBranchCreationPattern,
  EnvValue,
  EnvKey,
  MD5Hash,
  TagKey,
  AutoSubDomainCreationPattern,
  CustomDomain
}
import java.time.Instant
import zio.aws.amplify.model.primitives.OauthToken.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccessToken extends Subtype[String]
    type AccessToken = zio.aws.amplify.model.primitives.AccessToken.Type
    object ActiveJobId extends Subtype[String]
    type ActiveJobId = zio.aws.amplify.model.primitives.ActiveJobId.Type
    object AppArn extends Subtype[String]
    type AppArn = zio.aws.amplify.model.primitives.AppArn.Type
    object AppId extends Subtype[String]
    type AppId = zio.aws.amplify.model.primitives.AppId.Type
    object ArtifactFileName extends Subtype[String]
    type ArtifactFileName =
      zio.aws.amplify.model.primitives.ArtifactFileName.Type
    object ArtifactId extends Subtype[String]
    type ArtifactId = zio.aws.amplify.model.primitives.ArtifactId.Type
    object ArtifactUrl extends Subtype[String]
    type ArtifactUrl = zio.aws.amplify.model.primitives.ArtifactUrl.Type
    object ArtifactsUrl extends Subtype[String]
    type ArtifactsUrl = zio.aws.amplify.model.primitives.ArtifactsUrl.Type
    object AssociatedResource extends Subtype[String]
    type AssociatedResource =
      zio.aws.amplify.model.primitives.AssociatedResource.Type
    object AutoBranchCreationPattern extends Subtype[String]
    type AutoBranchCreationPattern =
      zio.aws.amplify.model.primitives.AutoBranchCreationPattern.Type
    object AutoSubDomainCreationPattern extends Subtype[String]
    type AutoSubDomainCreationPattern =
      zio.aws.amplify.model.primitives.AutoSubDomainCreationPattern.Type
    object AutoSubDomainIAMRole extends Subtype[String]
    type AutoSubDomainIAMRole =
      zio.aws.amplify.model.primitives.AutoSubDomainIAMRole.Type
    object BackendEnvironmentArn extends Subtype[String]
    type BackendEnvironmentArn =
      zio.aws.amplify.model.primitives.BackendEnvironmentArn.Type
    object BasicAuthCredentials extends Subtype[String]
    type BasicAuthCredentials =
      zio.aws.amplify.model.primitives.BasicAuthCredentials.Type
    object BranchArn extends Subtype[String]
    type BranchArn = zio.aws.amplify.model.primitives.BranchArn.Type
    object BranchName extends Subtype[String]
    type BranchName = zio.aws.amplify.model.primitives.BranchName.Type
    object BuildSpec extends Subtype[String]
    type BuildSpec = zio.aws.amplify.model.primitives.BuildSpec.Type
    object CertificateVerificationDNSRecord extends Subtype[String]
    type CertificateVerificationDNSRecord =
      zio.aws.amplify.model.primitives.CertificateVerificationDNSRecord.Type
    object CommitId extends Subtype[String]
    type CommitId = zio.aws.amplify.model.primitives.CommitId.Type
    object CommitMessage extends Subtype[String]
    type CommitMessage = zio.aws.amplify.model.primitives.CommitMessage.Type
    object CommitTime extends Subtype[Instant]
    type CommitTime = zio.aws.amplify.model.primitives.CommitTime.Type
    object Condition extends Subtype[String]
    type Condition = zio.aws.amplify.model.primitives.Condition.Type
    object Context extends Subtype[String]
    type Context = zio.aws.amplify.model.primitives.Context.Type
    object CreateTime extends Subtype[Instant]
    type CreateTime = zio.aws.amplify.model.primitives.CreateTime.Type
    object CustomDomain extends Subtype[String]
    type CustomDomain = zio.aws.amplify.model.primitives.CustomDomain.Type
    object CustomHeaders extends Subtype[String]
    type CustomHeaders = zio.aws.amplify.model.primitives.CustomHeaders.Type
    object DNSRecord extends Subtype[String]
    type DNSRecord = zio.aws.amplify.model.primitives.DNSRecord.Type
    object DefaultDomain extends Subtype[String]
    type DefaultDomain = zio.aws.amplify.model.primitives.DefaultDomain.Type
    object DeploymentArtifacts extends Subtype[String]
    type DeploymentArtifacts =
      zio.aws.amplify.model.primitives.DeploymentArtifacts.Type
    object Description extends Subtype[String]
    type Description = zio.aws.amplify.model.primitives.Description.Type
    object DisplayName extends Subtype[String]
    type DisplayName = zio.aws.amplify.model.primitives.DisplayName.Type
    object DomainAssociationArn extends Subtype[String]
    type DomainAssociationArn =
      zio.aws.amplify.model.primitives.DomainAssociationArn.Type
    object DomainName extends Subtype[String]
    type DomainName = zio.aws.amplify.model.primitives.DomainName.Type
    object DomainPrefix extends Subtype[String]
    type DomainPrefix = zio.aws.amplify.model.primitives.DomainPrefix.Type
    object EnableAutoBranchCreation extends Subtype[Boolean]
    type EnableAutoBranchCreation =
      zio.aws.amplify.model.primitives.EnableAutoBranchCreation.Type
    object EnableAutoBuild extends Subtype[Boolean]
    type EnableAutoBuild = zio.aws.amplify.model.primitives.EnableAutoBuild.Type
    object EnableAutoSubDomain extends Subtype[Boolean]
    type EnableAutoSubDomain =
      zio.aws.amplify.model.primitives.EnableAutoSubDomain.Type
    object EnableBasicAuth extends Subtype[Boolean]
    type EnableBasicAuth = zio.aws.amplify.model.primitives.EnableBasicAuth.Type
    object EnableBranchAutoBuild extends Subtype[Boolean]
    type EnableBranchAutoBuild =
      zio.aws.amplify.model.primitives.EnableBranchAutoBuild.Type
    object EnableBranchAutoDeletion extends Subtype[Boolean]
    type EnableBranchAutoDeletion =
      zio.aws.amplify.model.primitives.EnableBranchAutoDeletion.Type
    object EnableNotification extends Subtype[Boolean]
    type EnableNotification =
      zio.aws.amplify.model.primitives.EnableNotification.Type
    object EnablePerformanceMode extends Subtype[Boolean]
    type EnablePerformanceMode =
      zio.aws.amplify.model.primitives.EnablePerformanceMode.Type
    object EnablePullRequestPreview extends Subtype[Boolean]
    type EnablePullRequestPreview =
      zio.aws.amplify.model.primitives.EnablePullRequestPreview.Type
    object EndTime extends Subtype[Instant]
    type EndTime = zio.aws.amplify.model.primitives.EndTime.Type
    object EnvKey extends Subtype[String]
    type EnvKey = zio.aws.amplify.model.primitives.EnvKey.Type
    object EnvValue extends Subtype[String]
    type EnvValue = zio.aws.amplify.model.primitives.EnvValue.Type
    object EnvironmentName extends Subtype[String]
    type EnvironmentName = zio.aws.amplify.model.primitives.EnvironmentName.Type
    object FileName extends Subtype[String]
    type FileName = zio.aws.amplify.model.primitives.FileName.Type
    object Framework extends Subtype[String]
    type Framework = zio.aws.amplify.model.primitives.Framework.Type
    object JobArn extends Subtype[String]
    type JobArn = zio.aws.amplify.model.primitives.JobArn.Type
    object JobId extends Subtype[String]
    type JobId = zio.aws.amplify.model.primitives.JobId.Type
    object JobReason extends Subtype[String]
    type JobReason = zio.aws.amplify.model.primitives.JobReason.Type
    object LastDeployTime extends Subtype[Instant]
    type LastDeployTime = zio.aws.amplify.model.primitives.LastDeployTime.Type
    object LogUrl extends Subtype[String]
    type LogUrl = zio.aws.amplify.model.primitives.LogUrl.Type
    object MD5Hash extends Subtype[String]
    type MD5Hash = zio.aws.amplify.model.primitives.MD5Hash.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.amplify.model.primitives.MaxResults.Type
    object Name extends Subtype[String]
    type Name = zio.aws.amplify.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.amplify.model.primitives.NextToken.Type
    object OauthToken extends Subtype[String]
    type OauthToken = zio.aws.amplify.model.primitives.OauthToken.Type
    object PullRequestEnvironmentName extends Subtype[String]
    type PullRequestEnvironmentName =
      zio.aws.amplify.model.primitives.PullRequestEnvironmentName.Type
    object Repository extends Subtype[String]
    type Repository = zio.aws.amplify.model.primitives.Repository.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.amplify.model.primitives.ResourceArn.Type
    object ServiceRoleArn extends Subtype[String]
    type ServiceRoleArn = zio.aws.amplify.model.primitives.ServiceRoleArn.Type
    object Source extends Subtype[String]
    type Source = zio.aws.amplify.model.primitives.Source.Type
    object SourceUrl extends Subtype[String]
    type SourceUrl = zio.aws.amplify.model.primitives.SourceUrl.Type
    object StackName extends Subtype[String]
    type StackName = zio.aws.amplify.model.primitives.StackName.Type
    object StartTime extends Subtype[Instant]
    type StartTime = zio.aws.amplify.model.primitives.StartTime.Type
    object Status extends Subtype[String]
    type Status = zio.aws.amplify.model.primitives.Status.Type
    object StatusReason extends Subtype[String]
    type StatusReason = zio.aws.amplify.model.primitives.StatusReason.Type
    object StepName extends Subtype[String]
    type StepName = zio.aws.amplify.model.primitives.StepName.Type
    object TTL extends Subtype[String]
    type TTL = zio.aws.amplify.model.primitives.TTL.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.amplify.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.amplify.model.primitives.TagValue.Type
    object Target extends Subtype[String]
    type Target = zio.aws.amplify.model.primitives.Target.Type
    object TestArtifactsUrl extends Subtype[String]
    type TestArtifactsUrl =
      zio.aws.amplify.model.primitives.TestArtifactsUrl.Type
    object TestConfigUrl extends Subtype[String]
    type TestConfigUrl = zio.aws.amplify.model.primitives.TestConfigUrl.Type
    object ThumbnailName extends Subtype[String]
    type ThumbnailName = zio.aws.amplify.model.primitives.ThumbnailName.Type
    object ThumbnailUrl extends Subtype[String]
    type ThumbnailUrl = zio.aws.amplify.model.primitives.ThumbnailUrl.Type
    object TotalNumberOfJobs extends Subtype[String]
    type TotalNumberOfJobs =
      zio.aws.amplify.model.primitives.TotalNumberOfJobs.Type
    object UpdateTime extends Subtype[Instant]
    type UpdateTime = zio.aws.amplify.model.primitives.UpdateTime.Type
    object UploadUrl extends Subtype[String]
    type UploadUrl = zio.aws.amplify.model.primitives.UploadUrl.Type
    object Verified extends Subtype[Boolean]
    type Verified = zio.aws.amplify.model.primitives.Verified.Type
    object WebhookArn extends Subtype[String]
    type WebhookArn = zio.aws.amplify.model.primitives.WebhookArn.Type
    object WebhookId extends Subtype[String]
    type WebhookId = zio.aws.amplify.model.primitives.WebhookId.Type
    object WebhookUrl extends Subtype[String]
    type WebhookUrl = zio.aws.amplify.model.primitives.WebhookUrl.Type
  }
  type Apps = List[zio.aws.amplify.model.App]
  type Artifacts = List[zio.aws.amplify.model.Artifact]
  type AssociatedResources = List[AssociatedResource]
  type AutoBranchCreationPatterns = List[AutoBranchCreationPattern]
  type AutoSubDomainCreationPatterns = List[AutoSubDomainCreationPattern]
  type BackendEnvironments = List[zio.aws.amplify.model.BackendEnvironment]
  type Branches = List[zio.aws.amplify.model.Branch]
  type CustomDomains = List[CustomDomain]
  type CustomRules = List[zio.aws.amplify.model.CustomRule]
  type DomainAssociations = List[zio.aws.amplify.model.DomainAssociation]
  type EnvironmentVariables = Map[EnvKey, EnvValue]
  type FileMap = Map[FileName, MD5Hash]
  type FileUploadUrls = Map[FileName, UploadUrl]
  type JobSummaries = List[zio.aws.amplify.model.JobSummary]
  type Screenshots = Map[ThumbnailName, ThumbnailUrl]
  type Steps = List[zio.aws.amplify.model.Step]
  type SubDomainSettings = List[zio.aws.amplify.model.SubDomainSetting]
  type SubDomains = List[zio.aws.amplify.model.SubDomain]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type Webhooks = List[zio.aws.amplify.model.Webhook]
}
