package zio.aws.apigateway.model
import scala.jdk.CollectionConverters._
sealed trait AuthorizerType {
  def unwrap: software.amazon.awssdk.services.apigateway.model.AuthorizerType
}
object AuthorizerType {
  def wrap(
      value: software.amazon.awssdk.services.apigateway.model.AuthorizerType
  ): zio.aws.apigateway.model.AuthorizerType = value match {
    case software.amazon.awssdk.services.apigateway.model.AuthorizerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigateway.model.AuthorizerType.TOKEN =>
      val r = TOKEN
      r
    case software.amazon.awssdk.services.apigateway.model.AuthorizerType.REQUEST =>
      val r = REQUEST
      r
    case software.amazon.awssdk.services.apigateway.model.AuthorizerType.COGNITO_USER_POOLS =>
      val r = COGNITO_USER_POOLS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigateway.model.AuthorizerType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.AuthorizerType =
      software.amazon.awssdk.services.apigateway.model.AuthorizerType.UNKNOWN_TO_SDK_VERSION
  }
  case object TOKEN extends zio.aws.apigateway.model.AuthorizerType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.AuthorizerType =
      software.amazon.awssdk.services.apigateway.model.AuthorizerType.TOKEN
  }
  case object REQUEST extends zio.aws.apigateway.model.AuthorizerType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.AuthorizerType =
      software.amazon.awssdk.services.apigateway.model.AuthorizerType.REQUEST
  }
  case object COGNITO_USER_POOLS
      extends zio.aws.apigateway.model.AuthorizerType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.AuthorizerType =
      software.amazon.awssdk.services.apigateway.model.AuthorizerType.COGNITO_USER_POOLS
  }
}
