package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CanarySettings(
    percentTraffic: Optional[Double] = Optional.Absent,
    deploymentId: Optional[String] = Optional.Absent,
    stageVariableOverrides: Optional[Map[String, String]] = Optional.Absent,
    useStageCache: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CanarySettings = {
    import CanarySettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CanarySettings
      .builder()
      .optionallyWith(percentTraffic.map(value => value: java.lang.Double))(
        _.percentTraffic
      )
      .optionallyWith(deploymentId.map(value => value: java.lang.String))(
        _.deploymentId
      )
      .optionallyWith(
        stageVariableOverrides.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.stageVariableOverrides)
      .optionallyWith(useStageCache.map(value => value: java.lang.Boolean))(
        _.useStageCache
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CanarySettings.ReadOnly =
    zio.aws.apigateway.model.CanarySettings.wrap(buildAwsValue())
}
object CanarySettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CanarySettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CanarySettings =
      zio.aws.apigateway.model.CanarySettings(
        percentTraffic.map(value => value),
        deploymentId.map(value => value),
        stageVariableOverrides.map(value => value),
        useStageCache.map(value => value)
      )
    def percentTraffic: Optional[Double]
    def deploymentId: Optional[String]
    def stageVariableOverrides: Optional[Map[String, String]]
    def useStageCache: Optional[Boolean]
    def getPercentTraffic: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("percentTraffic", percentTraffic)
    def getDeploymentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getStageVariableOverrides: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField(
        "stageVariableOverrides",
        stageVariableOverrides
      )
    def getUseStageCache: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useStageCache", useStageCache)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CanarySettings
  ) extends zio.aws.apigateway.model.CanarySettings.ReadOnly {
    override val percentTraffic: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.percentTraffic())
      .map(value => value: Double)
    override val deploymentId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => value: String)
    override val stageVariableOverrides: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stageVariableOverrides())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val useStageCache: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useStageCache())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CanarySettings
  ): zio.aws.apigateway.model.CanarySettings.ReadOnly = new Wrapper(impl)
}
