package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.{NullableInteger, ProviderARN}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateAuthorizerRequest(
    restApiId: String,
    name: String,
    `type`: zio.aws.apigateway.model.AuthorizerType,
    providerARNs: Optional[Iterable[ProviderARN]] = Optional.Absent,
    authType: Optional[String] = Optional.Absent,
    authorizerUri: Optional[String] = Optional.Absent,
    authorizerCredentials: Optional[String] = Optional.Absent,
    identitySource: Optional[String] = Optional.Absent,
    identityValidationExpression: Optional[String] = Optional.Absent,
    authorizerResultTtlInSeconds: Optional[NullableInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest = {
    import CreateAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .name(name: java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        providerARNs.map(value =>
          value.map { item =>
            ProviderARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.providerARNs)
      .optionallyWith(authType.map(value => value: java.lang.String))(
        _.authType
      )
      .optionallyWith(authorizerUri.map(value => value: java.lang.String))(
        _.authorizerUri
      )
      .optionallyWith(
        authorizerCredentials.map(value => value: java.lang.String)
      )(_.authorizerCredentials)
      .optionallyWith(identitySource.map(value => value: java.lang.String))(
        _.identitySource
      )
      .optionallyWith(
        identityValidationExpression.map(value => value: java.lang.String)
      )(_.identityValidationExpression)
      .optionallyWith(
        authorizerResultTtlInSeconds.map(value => value: Integer)
      )(_.authorizerResultTtlInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateAuthorizerRequest.ReadOnly =
    zio.aws.apigateway.model.CreateAuthorizerRequest.wrap(buildAwsValue())
}
object CreateAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateAuthorizerRequest =
      zio.aws.apigateway.model.CreateAuthorizerRequest(
        restApiId,
        name,
        `type`,
        providerARNs.map(value => value),
        authType.map(value => value),
        authorizerUri.map(value => value),
        authorizerCredentials.map(value => value),
        identitySource.map(value => value),
        identityValidationExpression.map(value => value),
        authorizerResultTtlInSeconds.map(value => value)
      )
    def restApiId: String
    def name: String
    def `type`: zio.aws.apigateway.model.AuthorizerType
    def providerARNs: Optional[List[ProviderARN]]
    def authType: Optional[String]
    def authorizerUri: Optional[String]
    def authorizerCredentials: Optional[String]
    def identitySource: Optional[String]
    def identityValidationExpression: Optional[String]
    def authorizerResultTtlInSeconds: Optional[NullableInteger]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.apigateway.model.AuthorizerType] =
      ZIO.succeed(`type`)
    def getProviderARNs: ZIO[Any, AwsError, List[ProviderARN]] =
      AwsError.unwrapOptionField("providerARNs", providerARNs)
    def getAuthType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authType", authType)
    def getAuthorizerUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizerUri", authorizerUri)
    def getAuthorizerCredentials: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizerCredentials", authorizerCredentials)
    def getIdentitySource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identitySource", identitySource)
    def getIdentityValidationExpression: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "identityValidationExpression",
        identityValidationExpression
      )
    def getAuthorizerResultTtlInSeconds: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "authorizerResultTtlInSeconds",
        authorizerResultTtlInSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest
  ) extends zio.aws.apigateway.model.CreateAuthorizerRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val name: String = impl.name(): String
    override val `type`: zio.aws.apigateway.model.AuthorizerType =
      zio.aws.apigateway.model.AuthorizerType.wrap(impl.`type`())
    override val providerARNs: Optional[List[ProviderARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerARNs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.primitives.ProviderARN(item)
          }.toList
        )
    override val authType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authType())
      .map(value => value: String)
    override val authorizerUri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizerUri())
      .map(value => value: String)
    override val authorizerCredentials: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizerCredentials())
      .map(value => value: String)
    override val identitySource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.identitySource())
      .map(value => value: String)
    override val identityValidationExpression: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityValidationExpression())
        .map(value => value: String)
    override val authorizerResultTtlInSeconds: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizerResultTtlInSeconds())
        .map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest
  ): zio.aws.apigateway.model.CreateAuthorizerRequest.ReadOnly = new Wrapper(
    impl
  )
}
