package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDomainNameRequest(
    domainName: String,
    certificateName: Optional[String] = Optional.Absent,
    certificateBody: Optional[String] = Optional.Absent,
    certificatePrivateKey: Optional[String] = Optional.Absent,
    certificateChain: Optional[String] = Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent,
    regionalCertificateName: Optional[String] = Optional.Absent,
    regionalCertificateArn: Optional[String] = Optional.Absent,
    endpointConfiguration: Optional[
      zio.aws.apigateway.model.EndpointConfiguration
    ] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    securityPolicy: Optional[zio.aws.apigateway.model.SecurityPolicy] =
      Optional.Absent,
    mutualTlsAuthentication: Optional[
      zio.aws.apigateway.model.MutualTlsAuthenticationInput
    ] = Optional.Absent,
    ownershipVerificationCertificateArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest = {
    import CreateDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .optionallyWith(certificateName.map(value => value: java.lang.String))(
        _.certificateName
      )
      .optionallyWith(certificateBody.map(value => value: java.lang.String))(
        _.certificateBody
      )
      .optionallyWith(
        certificatePrivateKey.map(value => value: java.lang.String)
      )(_.certificatePrivateKey)
      .optionallyWith(certificateChain.map(value => value: java.lang.String))(
        _.certificateChain
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(
        regionalCertificateName.map(value => value: java.lang.String)
      )(_.regionalCertificateName)
      .optionallyWith(
        regionalCertificateArn.map(value => value: java.lang.String)
      )(_.regionalCertificateArn)
      .optionallyWith(
        endpointConfiguration.map(value => value.buildAwsValue())
      )(_.endpointConfiguration)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(securityPolicy.map(value => value.unwrap))(
        _.securityPolicy
      )
      .optionallyWith(
        mutualTlsAuthentication.map(value => value.buildAwsValue())
      )(_.mutualTlsAuthentication)
      .optionallyWith(
        ownershipVerificationCertificateArn.map(value =>
          value: java.lang.String
        )
      )(_.ownershipVerificationCertificateArn)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateDomainNameRequest.ReadOnly =
    zio.aws.apigateway.model.CreateDomainNameRequest.wrap(buildAwsValue())
}
object CreateDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateDomainNameRequest =
      zio.aws.apigateway.model.CreateDomainNameRequest(
        domainName,
        certificateName.map(value => value),
        certificateBody.map(value => value),
        certificatePrivateKey.map(value => value),
        certificateChain.map(value => value),
        certificateArn.map(value => value),
        regionalCertificateName.map(value => value),
        regionalCertificateArn.map(value => value),
        endpointConfiguration.map(value => value.asEditable),
        tags.map(value => value),
        securityPolicy.map(value => value),
        mutualTlsAuthentication.map(value => value.asEditable),
        ownershipVerificationCertificateArn.map(value => value)
      )
    def domainName: String
    def certificateName: Optional[String]
    def certificateBody: Optional[String]
    def certificatePrivateKey: Optional[String]
    def certificateChain: Optional[String]
    def certificateArn: Optional[String]
    def regionalCertificateName: Optional[String]
    def regionalCertificateArn: Optional[String]
    def endpointConfiguration
        : Optional[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly]
    def tags: Optional[Map[String, String]]
    def securityPolicy: Optional[zio.aws.apigateway.model.SecurityPolicy]
    def mutualTlsAuthentication: Optional[
      zio.aws.apigateway.model.MutualTlsAuthenticationInput.ReadOnly
    ]
    def ownershipVerificationCertificateArn: Optional[String]
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getCertificateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getCertificateBody: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateBody", certificateBody)
    def getCertificatePrivateKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificatePrivateKey", certificatePrivateKey)
    def getCertificateChain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateChain", certificateChain)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getRegionalCertificateName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("regionalCertificateName", regionalCertificateName)
    def getRegionalCertificateArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("regionalCertificateArn", regionalCertificateArn)
    def getEndpointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.EndpointConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("endpointConfiguration", endpointConfiguration)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSecurityPolicy
        : ZIO[Any, AwsError, zio.aws.apigateway.model.SecurityPolicy] =
      AwsError.unwrapOptionField("securityPolicy", securityPolicy)
    def getMutualTlsAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.MutualTlsAuthenticationInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mutualTlsAuthentication",
      mutualTlsAuthentication
    )
    def getOwnershipVerificationCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "ownershipVerificationCertificateArn",
        ownershipVerificationCertificateArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest
  ) extends zio.aws.apigateway.model.CreateDomainNameRequest.ReadOnly {
    override val domainName: String = impl.domainName(): String
    override val certificateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateName())
      .map(value => value: String)
    override val certificateBody: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateBody())
      .map(value => value: String)
    override val certificatePrivateKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificatePrivateKey())
      .map(value => value: String)
    override val certificateChain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateChain())
      .map(value => value: String)
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
    override val regionalCertificateName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionalCertificateName())
        .map(value => value: String)
    override val regionalCertificateArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionalCertificateArn())
        .map(value => value: String)
    override val endpointConfiguration
        : Optional[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointConfiguration())
        .map(value =>
          zio.aws.apigateway.model.EndpointConfiguration.wrap(value)
        )
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val securityPolicy
        : Optional[zio.aws.apigateway.model.SecurityPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityPolicy())
        .map(value => zio.aws.apigateway.model.SecurityPolicy.wrap(value))
    override val mutualTlsAuthentication: Optional[
      zio.aws.apigateway.model.MutualTlsAuthenticationInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mutualTlsAuthentication())
      .map(value =>
        zio.aws.apigateway.model.MutualTlsAuthenticationInput.wrap(value)
      )
    override val ownershipVerificationCertificateArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownershipVerificationCertificateArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest
  ): zio.aws.apigateway.model.CreateDomainNameRequest.ReadOnly = new Wrapper(
    impl
  )
}
