package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateUsagePlanKeyRequest(
    usagePlanId: String,
    keyId: String,
    keyType: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyRequest = {
    import CreateUsagePlanKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyRequest
      .builder()
      .usagePlanId(usagePlanId: java.lang.String)
      .keyId(keyId: java.lang.String)
      .keyType(keyType: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateUsagePlanKeyRequest.ReadOnly =
    zio.aws.apigateway.model.CreateUsagePlanKeyRequest.wrap(buildAwsValue())
}
object CreateUsagePlanKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateUsagePlanKeyRequest =
      zio.aws.apigateway.model
        .CreateUsagePlanKeyRequest(usagePlanId, keyId, keyType)
    def usagePlanId: String
    def keyId: String
    def keyType: String
    def getUsagePlanId: ZIO[Any, Nothing, String] = ZIO.succeed(usagePlanId)
    def getKeyId: ZIO[Any, Nothing, String] = ZIO.succeed(keyId)
    def getKeyType: ZIO[Any, Nothing, String] = ZIO.succeed(keyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyRequest
  ) extends zio.aws.apigateway.model.CreateUsagePlanKeyRequest.ReadOnly {
    override val usagePlanId: String = impl.usagePlanId(): String
    override val keyId: String = impl.keyId(): String
    override val keyType: String = impl.keyType(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyRequest
  ): zio.aws.apigateway.model.CreateUsagePlanKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
