package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetApiKeysResponse(
    warnings: Optional[Iterable[String]] = Optional.Absent,
    position: Optional[String] = Optional.Absent,
    items: Optional[Iterable[zio.aws.apigateway.model.ApiKey]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse = {
    import GetApiKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse
      .builder()
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.warnings)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetApiKeysResponse.ReadOnly =
    zio.aws.apigateway.model.GetApiKeysResponse.wrap(buildAwsValue())
}
object GetApiKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetApiKeysResponse =
      zio.aws.apigateway.model.GetApiKeysResponse(
        warnings.map(value => value),
        position.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def warnings: Optional[List[String]]
    def position: Optional[String]
    def items: Optional[List[zio.aws.apigateway.model.ApiKey.ReadOnly]]
    def getWarnings: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.apigateway.model.ApiKey.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse
  ) extends zio.aws.apigateway.model.GetApiKeysResponse.ReadOnly {
    override val warnings: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val items
        : Optional[List[zio.aws.apigateway.model.ApiKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.ApiKey.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse
  ): zio.aws.apigateway.model.GetApiKeysResponse.ReadOnly = new Wrapper(impl)
}
