package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.apigateway.model.primitives.StatusCode
import scala.jdk.CollectionConverters._
final case class GetIntegrationResponseRequest(
    restApiId: String,
    resourceId: String,
    httpMethod: String,
    statusCode: StatusCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseRequest = {
    import GetIntegrationResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .httpMethod(httpMethod: java.lang.String)
      .statusCode(StatusCode.unwrap(statusCode): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.GetIntegrationResponseRequest.ReadOnly =
    zio.aws.apigateway.model.GetIntegrationResponseRequest.wrap(buildAwsValue())
}
object GetIntegrationResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetIntegrationResponseRequest =
      zio.aws.apigateway.model.GetIntegrationResponseRequest(
        restApiId,
        resourceId,
        httpMethod,
        statusCode
      )
    def restApiId: String
    def resourceId: String
    def httpMethod: String
    def statusCode: StatusCode
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getHttpMethod: ZIO[Any, Nothing, String] = ZIO.succeed(httpMethod)
    def getStatusCode: ZIO[Any, Nothing, StatusCode] = ZIO.succeed(statusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseRequest
  ) extends zio.aws.apigateway.model.GetIntegrationResponseRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val httpMethod: String = impl.httpMethod(): String
    override val statusCode: StatusCode =
      zio.aws.apigateway.model.primitives.StatusCode(impl.statusCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseRequest
  ): zio.aws.apigateway.model.GetIntegrationResponseRequest.ReadOnly =
    new Wrapper(impl)
}
