package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMethodRequest(
    restApiId: String,
    resourceId: String,
    httpMethod: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetMethodRequest = {
    import GetMethodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetMethodRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .httpMethod(httpMethod: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetMethodRequest.ReadOnly =
    zio.aws.apigateway.model.GetMethodRequest.wrap(buildAwsValue())
}
object GetMethodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetMethodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetMethodRequest =
      zio.aws.apigateway.model
        .GetMethodRequest(restApiId, resourceId, httpMethod)
    def restApiId: String
    def resourceId: String
    def httpMethod: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getHttpMethod: ZIO[Any, Nothing, String] = ZIO.succeed(httpMethod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetMethodRequest
  ) extends zio.aws.apigateway.model.GetMethodRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val httpMethod: String = impl.httpMethod(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetMethodRequest
  ): zio.aws.apigateway.model.GetMethodRequest.ReadOnly = new Wrapper(impl)
}
