package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetModelResponse(
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    schema: Optional[String] = Optional.Absent,
    contentType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetModelResponse = {
    import GetModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetModelResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(schema.map(value => value: java.lang.String))(_.schema)
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetModelResponse.ReadOnly =
    zio.aws.apigateway.model.GetModelResponse.wrap(buildAwsValue())
}
object GetModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetModelResponse =
      zio.aws.apigateway.model.GetModelResponse(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        schema.map(value => value),
        contentType.map(value => value)
      )
    def id: Optional[String]
    def name: Optional[String]
    def description: Optional[String]
    def schema: Optional[String]
    def contentType: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSchema: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schema", schema)
    def getContentType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetModelResponse
  ) extends zio.aws.apigateway.model.GetModelResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val schema: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value => value: String)
    override val contentType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetModelResponse
  ): zio.aws.apigateway.model.GetModelResponse.ReadOnly = new Wrapper(impl)
}
