package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetModelTemplateResponse(
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetModelTemplateResponse = {
    import GetModelTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetModelTemplateResponse
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetModelTemplateResponse.ReadOnly =
    zio.aws.apigateway.model.GetModelTemplateResponse.wrap(buildAwsValue())
}
object GetModelTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetModelTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetModelTemplateResponse =
      zio.aws.apigateway.model
        .GetModelTemplateResponse(value.map(value => value))
    def value: Optional[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetModelTemplateResponse
  ) extends zio.aws.apigateway.model.GetModelTemplateResponse.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetModelTemplateResponse
  ): zio.aws.apigateway.model.GetModelTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
