package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.NullableInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetResourcesRequest(
    restApiId: String,
    position: Optional[String] = Optional.Absent,
    limit: Optional[NullableInteger] = Optional.Absent,
    embed: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetResourcesRequest = {
    import GetResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetResourcesRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .optionallyWith(
        embed.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.embed)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetResourcesRequest.ReadOnly =
    zio.aws.apigateway.model.GetResourcesRequest.wrap(buildAwsValue())
}
object GetResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetResourcesRequest =
      zio.aws.apigateway.model.GetResourcesRequest(
        restApiId,
        position.map(value => value),
        limit.map(value => value),
        embed.map(value => value)
      )
    def restApiId: String
    def position: Optional[String]
    def limit: Optional[NullableInteger]
    def embed: Optional[List[String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getEmbed: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("embed", embed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetResourcesRequest
  ) extends zio.aws.apigateway.model.GetResourcesRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val limit: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: NullableInteger)
    override val embed: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.embed())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetResourcesRequest
  ): zio.aws.apigateway.model.GetResourcesRequest.ReadOnly = new Wrapper(impl)
}
