package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportDocumentationPartsResponse(
    ids: Optional[Iterable[String]] = Optional.Absent,
    warnings: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsResponse = {
    import ImportDocumentationPartsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsResponse
      .builder()
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.warnings)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.ImportDocumentationPartsResponse.ReadOnly =
    zio.aws.apigateway.model.ImportDocumentationPartsResponse
      .wrap(buildAwsValue())
}
object ImportDocumentationPartsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.ImportDocumentationPartsResponse =
      zio.aws.apigateway.model.ImportDocumentationPartsResponse(
        ids.map(value => value),
        warnings.map(value => value)
      )
    def ids: Optional[List[String]]
    def warnings: Optional[List[String]]
    def getIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ids", ids)
    def getWarnings: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("warnings", warnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsResponse
  ) extends zio.aws.apigateway.model.ImportDocumentationPartsResponse.ReadOnly {
    override val ids: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val warnings: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsResponse
  ): zio.aws.apigateway.model.ImportDocumentationPartsResponse.ReadOnly =
    new Wrapper(impl)
}
