package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestInvokeAuthorizerRequest(
    restApiId: String,
    authorizerId: String,
    headers: Optional[Map[String, String]] = Optional.Absent,
    multiValueHeaders: Optional[Map[String, Iterable[String]]] =
      Optional.Absent,
    pathWithQueryString: Optional[String] = Optional.Absent,
    body: Optional[String] = Optional.Absent,
    stageVariables: Optional[Map[String, String]] = Optional.Absent,
    additionalContext: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest = {
    import TestInvokeAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .authorizerId(authorizerId: java.lang.String)
      .optionallyWith(
        headers.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.headers)
      .optionallyWith(
        multiValueHeaders.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.multiValueHeaders)
      .optionallyWith(
        pathWithQueryString.map(value => value: java.lang.String)
      )(_.pathWithQueryString)
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        stageVariables.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.stageVariables)
      .optionallyWith(
        additionalContext.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.additionalContext)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.TestInvokeAuthorizerRequest.ReadOnly =
    zio.aws.apigateway.model.TestInvokeAuthorizerRequest.wrap(buildAwsValue())
}
object TestInvokeAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.TestInvokeAuthorizerRequest =
      zio.aws.apigateway.model.TestInvokeAuthorizerRequest(
        restApiId,
        authorizerId,
        headers.map(value => value),
        multiValueHeaders.map(value => value),
        pathWithQueryString.map(value => value),
        body.map(value => value),
        stageVariables.map(value => value),
        additionalContext.map(value => value)
      )
    def restApiId: String
    def authorizerId: String
    def headers: Optional[Map[String, String]]
    def multiValueHeaders: Optional[Map[String, List[String]]]
    def pathWithQueryString: Optional[String]
    def body: Optional[String]
    def stageVariables: Optional[Map[String, String]]
    def additionalContext: Optional[Map[String, String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getAuthorizerId: ZIO[Any, Nothing, String] = ZIO.succeed(authorizerId)
    def getHeaders: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("headers", headers)
    def getMultiValueHeaders: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("multiValueHeaders", multiValueHeaders)
    def getPathWithQueryString: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pathWithQueryString", pathWithQueryString)
    def getBody: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("body", body)
    def getStageVariables: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("stageVariables", stageVariables)
    def getAdditionalContext: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("additionalContext", additionalContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest
  ) extends zio.aws.apigateway.model.TestInvokeAuthorizerRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val authorizerId: String = impl.authorizerId(): String
    override val headers: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.headers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val multiValueHeaders: Optional[Map[String, List[String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multiValueHeaders())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
    override val pathWithQueryString: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pathWithQueryString())
      .map(value => value: String)
    override val body: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: String)
    override val stageVariables: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stageVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val additionalContext: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalContext())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest
  ): zio.aws.apigateway.model.TestInvokeAuthorizerRequest.ReadOnly =
    new Wrapper(impl)
}
