package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateUsagePlanResponse(
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    apiStages: Optional[Iterable[zio.aws.apigateway.model.ApiStage]] =
      Optional.Absent,
    throttle: Optional[zio.aws.apigateway.model.ThrottleSettings] =
      Optional.Absent,
    quota: Optional[zio.aws.apigateway.model.QuotaSettings] = Optional.Absent,
    productCode: Optional[String] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanResponse = {
    import UpdateUsagePlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        apiStages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.apiStages)
      .optionallyWith(throttle.map(value => value.buildAwsValue()))(_.throttle)
      .optionallyWith(quota.map(value => value.buildAwsValue()))(_.quota)
      .optionallyWith(productCode.map(value => value: java.lang.String))(
        _.productCode
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateUsagePlanResponse.ReadOnly =
    zio.aws.apigateway.model.UpdateUsagePlanResponse.wrap(buildAwsValue())
}
object UpdateUsagePlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateUsagePlanResponse =
      zio.aws.apigateway.model.UpdateUsagePlanResponse(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        apiStages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        throttle.map(value => value.asEditable),
        quota.map(value => value.asEditable),
        productCode.map(value => value),
        tags.map(value => value)
      )
    def id: Optional[String]
    def name: Optional[String]
    def description: Optional[String]
    def apiStages: Optional[List[zio.aws.apigateway.model.ApiStage.ReadOnly]]
    def throttle: Optional[zio.aws.apigateway.model.ThrottleSettings.ReadOnly]
    def quota: Optional[zio.aws.apigateway.model.QuotaSettings.ReadOnly]
    def productCode: Optional[String]
    def tags: Optional[Map[String, String]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getApiStages
        : ZIO[Any, AwsError, List[zio.aws.apigateway.model.ApiStage.ReadOnly]] =
      AwsError.unwrapOptionField("apiStages", apiStages)
    def getThrottle: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.ThrottleSettings.ReadOnly
    ] = AwsError.unwrapOptionField("throttle", throttle)
    def getQuota
        : ZIO[Any, AwsError, zio.aws.apigateway.model.QuotaSettings.ReadOnly] =
      AwsError.unwrapOptionField("quota", quota)
    def getProductCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productCode", productCode)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanResponse
  ) extends zio.aws.apigateway.model.UpdateUsagePlanResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val apiStages
        : Optional[List[zio.aws.apigateway.model.ApiStage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiStages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.ApiStage.wrap(item)
          }.toList
        )
    override val throttle
        : Optional[zio.aws.apigateway.model.ThrottleSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throttle())
        .map(value => zio.aws.apigateway.model.ThrottleSettings.wrap(value))
    override val quota
        : Optional[zio.aws.apigateway.model.QuotaSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quota())
        .map(value => zio.aws.apigateway.model.QuotaSettings.wrap(value))
    override val productCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.productCode())
      .map(value => value: String)
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanResponse
  ): zio.aws.apigateway.model.UpdateUsagePlanResponse.ReadOnly = new Wrapper(
    impl
  )
}
