package zio.aws.apigateway
import zio.aws.apigateway.model.ApiKey.ReadOnly
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.apigateway.model.{
  FlushStageAuthorizersCacheRequest,
  GetDocumentationVersionRequest,
  UpdateIntegrationRequest,
  DeleteDeploymentRequest,
  GetUsagePlanKeysRequest,
  GetSdkRequest,
  GetBasePathMappingsRequest,
  GetDomainNamesRequest,
  DeleteApiKeyRequest,
  UpdateDocumentationVersionRequest,
  GetMethodResponseRequest,
  GetBasePathMappingRequest,
  UpdateUsagePlanRequest,
  CreateStageRequest,
  CreateApiKeyRequest,
  CreateVpcLinkRequest,
  UpdateIntegrationResponseRequest,
  DeleteUsagePlanKeyRequest,
  GenerateClientCertificateRequest,
  ImportRestApiRequest,
  GetGatewayResponseRequest,
  UpdateDeploymentRequest,
  GetIntegrationRequest,
  DeleteVpcLinkRequest,
  UpdateMethodRequest,
  GetRestApiRequest,
  UpdateVpcLinkRequest,
  DeleteStageRequest,
  GetAuthorizerRequest,
  CreateAuthorizerRequest,
  PutIntegrationResponseRequest,
  GetStagesRequest,
  PutGatewayResponseRequest,
  UpdateClientCertificateRequest,
  GetUsagePlansRequest,
  DeleteClientCertificateRequest,
  DeleteUsagePlanRequest,
  PutMethodResponseRequest,
  GetDeploymentsRequest,
  PutMethodRequest,
  CreateUsagePlanKeyRequest,
  TestInvokeMethodRequest,
  GetClientCertificateRequest,
  UpdateAccountRequest,
  CreateModelRequest,
  DeleteIntegrationRequest,
  DeleteGatewayResponseRequest,
  PutRestApiRequest,
  GetRestApisRequest,
  GetIntegrationResponseRequest,
  CreateRestApiRequest,
  GetSdkTypeRequest,
  GetUsagePlanKeyRequest,
  DeleteAuthorizerRequest,
  DeleteRequestValidatorRequest,
  GetSdkTypesRequest,
  CreateRequestValidatorRequest,
  GetClientCertificatesRequest,
  DeleteResourceRequest,
  GetVpcLinksRequest,
  CreateDocumentationVersionRequest,
  GetApiKeyRequest,
  GetUsagePlanRequest,
  GetAccountRequest,
  GetResourceRequest,
  DeleteDocumentationVersionRequest,
  GetModelTemplateRequest,
  DeleteDomainNameRequest,
  GetDocumentationPartRequest,
  ImportDocumentationPartsRequest,
  UpdateDomainNameRequest,
  CreateDomainNameRequest,
  GetVpcLinkRequest,
  UpdateBasePathMappingRequest,
  DeleteDocumentationPartRequest,
  ImportApiKeysRequest,
  CreateResourceRequest,
  DeleteRestApiRequest,
  GetApiKeysRequest,
  DeleteMethodRequest,
  UntagResourceRequest,
  GetStageRequest,
  FlushStageCacheRequest,
  CreateUsagePlanRequest,
  UpdateStageRequest,
  GetTagsRequest,
  GetDocumentationVersionsRequest,
  DeleteMethodResponseRequest,
  DeleteIntegrationResponseRequest,
  UpdateRestApiRequest,
  GetExportRequest,
  CreateDeploymentRequest,
  UpdateModelRequest,
  UpdateMethodResponseRequest,
  GetModelRequest,
  CreateBasePathMappingRequest,
  GetDeploymentRequest,
  CreateDocumentationPartRequest,
  GetUsageRequest,
  TestInvokeAuthorizerRequest,
  GetResourcesRequest,
  GetModelsRequest,
  DeleteModelRequest,
  UpdateRequestValidatorRequest,
  GetGatewayResponsesRequest,
  GetAuthorizersRequest,
  GetRequestValidatorsRequest,
  GetDomainNameRequest,
  UpdateResourceRequest,
  PutIntegrationRequest,
  UpdateUsageRequest,
  UpdateGatewayResponseRequest,
  GetRequestValidatorRequest,
  GetMethodRequest,
  TagResourceRequest,
  UpdateAuthorizerRequest,
  DeleteBasePathMappingRequest,
  GetDocumentationPartsRequest,
  UpdateApiKeyRequest,
  UpdateDocumentationPartRequest
}
import zio.stream.ZStream
object ApiGatewayMock extends Mock[ApiGateway] {
  object GetResource
      extends Effect[
        GetResourceRequest,
        AwsError,
        zio.aws.apigateway.model.GetResourceResponse.ReadOnly
      ]
  object UpdateAccount
      extends Effect[
        UpdateAccountRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateAccountResponse.ReadOnly
      ]
  object UpdateStage
      extends Effect[
        UpdateStageRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateStageResponse.ReadOnly
      ]
  object GetVpcLinks
      extends Stream[
        GetVpcLinksRequest,
        AwsError,
        zio.aws.apigateway.model.VpcLink.ReadOnly
      ]
  object GetVpcLinksPaginated
      extends Effect[
        GetVpcLinksRequest,
        AwsError,
        zio.aws.apigateway.model.GetVpcLinksResponse.ReadOnly
      ]
  object CreateResource
      extends Effect[
        CreateResourceRequest,
        AwsError,
        zio.aws.apigateway.model.CreateResourceResponse.ReadOnly
      ]
  object DeleteDocumentationVersion
      extends Effect[DeleteDocumentationVersionRequest, AwsError, Unit]
  object TestInvokeAuthorizer
      extends Effect[
        TestInvokeAuthorizerRequest,
        AwsError,
        zio.aws.apigateway.model.TestInvokeAuthorizerResponse.ReadOnly
      ]
  object GetRequestValidators
      extends Effect[
        GetRequestValidatorsRequest,
        AwsError,
        zio.aws.apigateway.model.GetRequestValidatorsResponse.ReadOnly
      ]
  object GetDocumentationPart
      extends Effect[
        GetDocumentationPartRequest,
        AwsError,
        zio.aws.apigateway.model.GetDocumentationPartResponse.ReadOnly
      ]
  object UpdateResource
      extends Effect[
        UpdateResourceRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateResourceResponse.ReadOnly
      ]
  object DeleteRestApi extends Effect[DeleteRestApiRequest, AwsError, Unit]
  object GetMethod
      extends Effect[
        GetMethodRequest,
        AwsError,
        zio.aws.apigateway.model.GetMethodResponse.ReadOnly
      ]
  object DeleteUsagePlan extends Effect[DeleteUsagePlanRequest, AwsError, Unit]
  object GetDomainNames
      extends Stream[
        GetDomainNamesRequest,
        AwsError,
        zio.aws.apigateway.model.DomainName.ReadOnly
      ]
  object GetDomainNamesPaginated
      extends Effect[
        GetDomainNamesRequest,
        AwsError,
        zio.aws.apigateway.model.GetDomainNamesResponse.ReadOnly
      ]
  object CreateBasePathMapping
      extends Effect[
        CreateBasePathMappingRequest,
        AwsError,
        zio.aws.apigateway.model.CreateBasePathMappingResponse.ReadOnly
      ]
  object UpdateBasePathMapping
      extends Effect[
        UpdateBasePathMappingRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateBasePathMappingResponse.ReadOnly
      ]
  object CreateModel
      extends Effect[
        CreateModelRequest,
        AwsError,
        zio.aws.apigateway.model.CreateModelResponse.ReadOnly
      ]
  object GetMethodResponse
      extends Effect[
        GetMethodResponseRequest,
        AwsError,
        zio.aws.apigateway.model.GetMethodResponseResponse.ReadOnly
      ]
  object GetClientCertificates
      extends Stream[
        GetClientCertificatesRequest,
        AwsError,
        zio.aws.apigateway.model.ClientCertificate.ReadOnly
      ]
  object GetClientCertificatesPaginated
      extends Effect[
        GetClientCertificatesRequest,
        AwsError,
        zio.aws.apigateway.model.GetClientCertificatesResponse.ReadOnly
      ]
  object CreateUsagePlan
      extends Effect[
        CreateUsagePlanRequest,
        AwsError,
        zio.aws.apigateway.model.CreateUsagePlanResponse.ReadOnly
      ]
  object UpdateApiKey
      extends Effect[
        UpdateApiKeyRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateApiKeyResponse.ReadOnly
      ]
  object UpdateModel
      extends Effect[
        UpdateModelRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateModelResponse.ReadOnly
      ]
  object CreateDocumentationPart
      extends Effect[
        CreateDocumentationPartRequest,
        AwsError,
        zio.aws.apigateway.model.CreateDocumentationPartResponse.ReadOnly
      ]
  object GetDocumentationParts
      extends Effect[
        GetDocumentationPartsRequest,
        AwsError,
        zio.aws.apigateway.model.GetDocumentationPartsResponse.ReadOnly
      ]
  object DeleteVpcLink extends Effect[DeleteVpcLinkRequest, AwsError, Unit]
  object GetVpcLink
      extends Effect[
        GetVpcLinkRequest,
        AwsError,
        zio.aws.apigateway.model.GetVpcLinkResponse.ReadOnly
      ]
  object CreateRequestValidator
      extends Effect[
        CreateRequestValidatorRequest,
        AwsError,
        zio.aws.apigateway.model.CreateRequestValidatorResponse.ReadOnly
      ]
  object TestInvokeMethod
      extends Effect[
        TestInvokeMethodRequest,
        AwsError,
        zio.aws.apigateway.model.TestInvokeMethodResponse.ReadOnly
      ]
  object DeleteUsagePlanKey
      extends Effect[DeleteUsagePlanKeyRequest, AwsError, Unit]
  object PutIntegrationResponse
      extends Effect[
        PutIntegrationResponseRequest,
        AwsError,
        zio.aws.apigateway.model.PutIntegrationResponseResponse.ReadOnly
      ]
  object GetDeployment
      extends Effect[
        GetDeploymentRequest,
        AwsError,
        zio.aws.apigateway.model.GetDeploymentResponse.ReadOnly
      ]
  object DeleteDeployment
      extends Effect[DeleteDeploymentRequest, AwsError, Unit]
  object FlushStageCache extends Effect[FlushStageCacheRequest, AwsError, Unit]
  object GetStage
      extends Effect[
        GetStageRequest,
        AwsError,
        zio.aws.apigateway.model.GetStageResponse.ReadOnly
      ]
  object DeleteIntegration
      extends Effect[DeleteIntegrationRequest, AwsError, Unit]
  object UpdateDeployment
      extends Effect[
        UpdateDeploymentRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateDeploymentResponse.ReadOnly
      ]
  object GetIntegrationResponse
      extends Effect[
        GetIntegrationResponseRequest,
        AwsError,
        zio.aws.apigateway.model.GetIntegrationResponseResponse.ReadOnly
      ]
  object DeleteMethodResponse
      extends Effect[DeleteMethodResponseRequest, AwsError, Unit]
  object GetGatewayResponses
      extends Effect[
        GetGatewayResponsesRequest,
        AwsError,
        zio.aws.apigateway.model.GetGatewayResponsesResponse.ReadOnly
      ]
  object GetAccount
      extends Effect[
        GetAccountRequest,
        AwsError,
        zio.aws.apigateway.model.GetAccountResponse.ReadOnly
      ]
  object UpdateVpcLink
      extends Effect[
        UpdateVpcLinkRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateVpcLinkResponse.ReadOnly
      ]
  object GetUsage
      extends Effect[
        GetUsageRequest,
        AwsError,
        zio.aws.apigateway.model.GetUsageResponse.ReadOnly
      ]
  object GetSdkType
      extends Effect[
        GetSdkTypeRequest,
        AwsError,
        zio.aws.apigateway.model.GetSdkTypeResponse.ReadOnly
      ]
  object GetExport
      extends Effect[
        GetExportRequest,
        AwsError,
        zio.aws.apigateway.model.GetExportResponse.ReadOnly
      ]
  object GetModel
      extends Effect[
        GetModelRequest,
        AwsError,
        zio.aws.apigateway.model.GetModelResponse.ReadOnly
      ]
  object CreateRestApi
      extends Effect[
        CreateRestApiRequest,
        AwsError,
        zio.aws.apigateway.model.CreateRestApiResponse.ReadOnly
      ]
  object DeleteDocumentationPart
      extends Effect[DeleteDocumentationPartRequest, AwsError, Unit]
  object UpdateAuthorizer
      extends Effect[
        UpdateAuthorizerRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateAuthorizerResponse.ReadOnly
      ]
  object PutMethodResponse
      extends Effect[
        PutMethodResponseRequest,
        AwsError,
        zio.aws.apigateway.model.PutMethodResponseResponse.ReadOnly
      ]
  object CreateDocumentationVersion
      extends Effect[
        CreateDocumentationVersionRequest,
        AwsError,
        zio.aws.apigateway.model.CreateDocumentationVersionResponse.ReadOnly
      ]
  object DeleteStage extends Effect[DeleteStageRequest, AwsError, Unit]
  object FlushStageAuthorizersCache
      extends Effect[FlushStageAuthorizersCacheRequest, AwsError, Unit]
  object GetApiKeys extends Stream[GetApiKeysRequest, AwsError, ReadOnly]
  object GetApiKeysPaginated
      extends Effect[
        GetApiKeysRequest,
        AwsError,
        zio.aws.apigateway.model.GetApiKeysResponse.ReadOnly
      ]
  object UpdateUsage
      extends Effect[
        UpdateUsageRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateUsageResponse.ReadOnly
      ]
  object DeleteModel extends Effect[DeleteModelRequest, AwsError, Unit]
  object DeleteMethod extends Effect[DeleteMethodRequest, AwsError, Unit]
  object GetClientCertificate
      extends Effect[
        GetClientCertificateRequest,
        AwsError,
        zio.aws.apigateway.model.GetClientCertificateResponse.ReadOnly
      ]
  object GetRestApis
      extends Stream[
        GetRestApisRequest,
        AwsError,
        zio.aws.apigateway.model.RestApi.ReadOnly
      ]
  object GetRestApisPaginated
      extends Effect[
        GetRestApisRequest,
        AwsError,
        zio.aws.apigateway.model.GetRestApisResponse.ReadOnly
      ]
  object CreateDomainName
      extends Effect[
        CreateDomainNameRequest,
        AwsError,
        zio.aws.apigateway.model.CreateDomainNameResponse.ReadOnly
      ]
  object GetResources
      extends Stream[
        GetResourcesRequest,
        AwsError,
        zio.aws.apigateway.model.Resource.ReadOnly
      ]
  object GetResourcesPaginated
      extends Effect[
        GetResourcesRequest,
        AwsError,
        zio.aws.apigateway.model.GetResourcesResponse.ReadOnly
      ]
  object GetDocumentationVersion
      extends Effect[
        GetDocumentationVersionRequest,
        AwsError,
        zio.aws.apigateway.model.GetDocumentationVersionResponse.ReadOnly
      ]
  object UpdateClientCertificate
      extends Effect[
        UpdateClientCertificateRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateClientCertificateResponse.ReadOnly
      ]
  object ImportApiKeys
      extends Effect[
        ImportApiKeysRequest,
        AwsError,
        zio.aws.apigateway.model.ImportApiKeysResponse.ReadOnly
      ]
  object CreateVpcLink
      extends Effect[
        CreateVpcLinkRequest,
        AwsError,
        zio.aws.apigateway.model.CreateVpcLinkResponse.ReadOnly
      ]
  object GetApiKey
      extends Effect[
        GetApiKeyRequest,
        AwsError,
        zio.aws.apigateway.model.GetApiKeyResponse.ReadOnly
      ]
  object DeleteClientCertificate
      extends Effect[DeleteClientCertificateRequest, AwsError, Unit]
  object UpdateRestApi
      extends Effect[
        UpdateRestApiRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateRestApiResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object GetAuthorizers
      extends Effect[
        GetAuthorizersRequest,
        AwsError,
        zio.aws.apigateway.model.GetAuthorizersResponse.ReadOnly
      ]
  object UpdateIntegrationResponse
      extends Effect[
        UpdateIntegrationResponseRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateIntegrationResponseResponse.ReadOnly
      ]
  object DeleteApiKey extends Effect[DeleteApiKeyRequest, AwsError, Unit]
  object CreateDeployment
      extends Effect[
        CreateDeploymentRequest,
        AwsError,
        zio.aws.apigateway.model.CreateDeploymentResponse.ReadOnly
      ]
  object UpdateDocumentationPart
      extends Effect[
        UpdateDocumentationPartRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateDocumentationPartResponse.ReadOnly
      ]
  object CreateApiKey
      extends Effect[
        CreateApiKeyRequest,
        AwsError,
        zio.aws.apigateway.model.CreateApiKeyResponse.ReadOnly
      ]
  object PutIntegration
      extends Effect[
        PutIntegrationRequest,
        AwsError,
        zio.aws.apigateway.model.PutIntegrationResponse.ReadOnly
      ]
  object ImportDocumentationParts
      extends Effect[
        ImportDocumentationPartsRequest,
        AwsError,
        zio.aws.apigateway.model.ImportDocumentationPartsResponse.ReadOnly
      ]
  object GetModelTemplate
      extends Effect[
        GetModelTemplateRequest,
        AwsError,
        zio.aws.apigateway.model.GetModelTemplateResponse.ReadOnly
      ]
  object CreateStage
      extends Effect[
        CreateStageRequest,
        AwsError,
        zio.aws.apigateway.model.CreateStageResponse.ReadOnly
      ]
  object GetUsagePlanKey
      extends Effect[
        GetUsagePlanKeyRequest,
        AwsError,
        zio.aws.apigateway.model.GetUsagePlanKeyResponse.ReadOnly
      ]
  object UpdateMethodResponse
      extends Effect[
        UpdateMethodResponseRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateMethodResponseResponse.ReadOnly
      ]
  object GetRestApi
      extends Effect[
        GetRestApiRequest,
        AwsError,
        zio.aws.apigateway.model.GetRestApiResponse.ReadOnly
      ]
  object CreateAuthorizer
      extends Effect[
        CreateAuthorizerRequest,
        AwsError,
        zio.aws.apigateway.model.CreateAuthorizerResponse.ReadOnly
      ]
  object PutMethod
      extends Effect[
        PutMethodRequest,
        AwsError,
        zio.aws.apigateway.model.PutMethodResponse.ReadOnly
      ]
  object GetGatewayResponse
      extends Effect[
        GetGatewayResponseRequest,
        AwsError,
        zio.aws.apigateway.model.GetGatewayResponseResponse.ReadOnly
      ]
  object GenerateClientCertificate
      extends Effect[
        GenerateClientCertificateRequest,
        AwsError,
        zio.aws.apigateway.model.GenerateClientCertificateResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object GetUsagePlan
      extends Effect[
        GetUsagePlanRequest,
        AwsError,
        zio.aws.apigateway.model.GetUsagePlanResponse.ReadOnly
      ]
  object CreateUsagePlanKey
      extends Effect[
        CreateUsagePlanKeyRequest,
        AwsError,
        zio.aws.apigateway.model.CreateUsagePlanKeyResponse.ReadOnly
      ]
  object UpdateUsagePlan
      extends Effect[
        UpdateUsagePlanRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateUsagePlanResponse.ReadOnly
      ]
  object GetIntegration
      extends Effect[
        GetIntegrationRequest,
        AwsError,
        zio.aws.apigateway.model.GetIntegrationResponse.ReadOnly
      ]
  object GetDeployments
      extends Stream[
        GetDeploymentsRequest,
        AwsError,
        zio.aws.apigateway.model.Deployment.ReadOnly
      ]
  object GetDeploymentsPaginated
      extends Effect[
        GetDeploymentsRequest,
        AwsError,
        zio.aws.apigateway.model.GetDeploymentsResponse.ReadOnly
      ]
  object PutRestApi
      extends Effect[
        PutRestApiRequest,
        AwsError,
        zio.aws.apigateway.model.PutRestApiResponse.ReadOnly
      ]
  object GetUsagePlans
      extends Stream[
        GetUsagePlansRequest,
        AwsError,
        zio.aws.apigateway.model.UsagePlan.ReadOnly
      ]
  object GetUsagePlansPaginated
      extends Effect[
        GetUsagePlansRequest,
        AwsError,
        zio.aws.apigateway.model.GetUsagePlansResponse.ReadOnly
      ]
  object GetSdk
      extends Effect[
        GetSdkRequest,
        AwsError,
        zio.aws.apigateway.model.GetSdkResponse.ReadOnly
      ]
  object DeleteAuthorizer
      extends Effect[DeleteAuthorizerRequest, AwsError, Unit]
  object GetBasePathMapping
      extends Effect[
        GetBasePathMappingRequest,
        AwsError,
        zio.aws.apigateway.model.GetBasePathMappingResponse.ReadOnly
      ]
  object DeleteRequestValidator
      extends Effect[DeleteRequestValidatorRequest, AwsError, Unit]
  object GetSdkTypes
      extends Effect[
        GetSdkTypesRequest,
        AwsError,
        zio.aws.apigateway.model.GetSdkTypesResponse.ReadOnly
      ]
  object GetUsagePlanKeys
      extends Stream[
        GetUsagePlanKeysRequest,
        AwsError,
        zio.aws.apigateway.model.UsagePlanKey.ReadOnly
      ]
  object GetUsagePlanKeysPaginated
      extends Effect[
        GetUsagePlanKeysRequest,
        AwsError,
        zio.aws.apigateway.model.GetUsagePlanKeysResponse.ReadOnly
      ]
  object DeleteIntegrationResponse
      extends Effect[DeleteIntegrationResponseRequest, AwsError, Unit]
  object UpdateMethod
      extends Effect[
        UpdateMethodRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateMethodResponse.ReadOnly
      ]
  object UpdateIntegration
      extends Effect[
        UpdateIntegrationRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateIntegrationResponse.ReadOnly
      ]
  object ImportRestApi
      extends Effect[
        ImportRestApiRequest,
        AwsError,
        zio.aws.apigateway.model.ImportRestApiResponse.ReadOnly
      ]
  object DeleteGatewayResponse
      extends Effect[DeleteGatewayResponseRequest, AwsError, Unit]
  object UpdateGatewayResponse
      extends Effect[
        UpdateGatewayResponseRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateGatewayResponseResponse.ReadOnly
      ]
  object UpdateDocumentationVersion
      extends Effect[
        UpdateDocumentationVersionRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateDocumentationVersionResponse.ReadOnly
      ]
  object PutGatewayResponse
      extends Effect[
        PutGatewayResponseRequest,
        AwsError,
        zio.aws.apigateway.model.PutGatewayResponseResponse.ReadOnly
      ]
  object GetRequestValidator
      extends Effect[
        GetRequestValidatorRequest,
        AwsError,
        zio.aws.apigateway.model.GetRequestValidatorResponse.ReadOnly
      ]
  object GetModels
      extends Stream[
        GetModelsRequest,
        AwsError,
        zio.aws.apigateway.model.Model.ReadOnly
      ]
  object GetModelsPaginated
      extends Effect[
        GetModelsRequest,
        AwsError,
        zio.aws.apigateway.model.GetModelsResponse.ReadOnly
      ]
  object GetStages
      extends Effect[
        GetStagesRequest,
        AwsError,
        zio.aws.apigateway.model.GetStagesResponse.ReadOnly
      ]
  object GetDomainName
      extends Effect[
        GetDomainNameRequest,
        AwsError,
        zio.aws.apigateway.model.GetDomainNameResponse.ReadOnly
      ]
  object GetDocumentationVersions
      extends Effect[
        GetDocumentationVersionsRequest,
        AwsError,
        zio.aws.apigateway.model.GetDocumentationVersionsResponse.ReadOnly
      ]
  object GetAuthorizer
      extends Effect[
        GetAuthorizerRequest,
        AwsError,
        zio.aws.apigateway.model.GetAuthorizerResponse.ReadOnly
      ]
  object DeleteDomainName
      extends Effect[DeleteDomainNameRequest, AwsError, Unit]
  object UpdateRequestValidator
      extends Effect[
        UpdateRequestValidatorRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateRequestValidatorResponse.ReadOnly
      ]
  object GetBasePathMappings
      extends Stream[
        GetBasePathMappingsRequest,
        AwsError,
        zio.aws.apigateway.model.BasePathMapping.ReadOnly
      ]
  object GetBasePathMappingsPaginated
      extends Effect[
        GetBasePathMappingsRequest,
        AwsError,
        zio.aws.apigateway.model.GetBasePathMappingsResponse.ReadOnly
      ]
  object DeleteBasePathMapping
      extends Effect[DeleteBasePathMappingRequest, AwsError, Unit]
  object UpdateDomainName
      extends Effect[
        UpdateDomainNameRequest,
        AwsError,
        zio.aws.apigateway.model.UpdateDomainNameResponse.ReadOnly
      ]
  object DeleteResource extends Effect[DeleteResourceRequest, AwsError, Unit]
  object GetTags
      extends Effect[
        GetTagsRequest,
        AwsError,
        zio.aws.apigateway.model.GetTagsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ApiGateway] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ApiGateway {
          val api: ApiGatewayAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ApiGateway = this
          def getResource(request: GetResourceRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetResourceResponse.ReadOnly
          ] = proxy(GetResource, request)
          def updateAccount(request: UpdateAccountRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateAccountResponse.ReadOnly
          ] = proxy(UpdateAccount, request)
          def updateStage(request: UpdateStageRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateStageResponse.ReadOnly
          ] = proxy(UpdateStage, request)
          def getVpcLinks(
              request: GetVpcLinksRequest
          ): ZStream[Any, AwsError, zio.aws.apigateway.model.VpcLink.ReadOnly] =
            rts.unsafeRun(proxy(GetVpcLinks, request))
          def getVpcLinksPaginated(request: GetVpcLinksRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetVpcLinksResponse.ReadOnly
          ] = proxy(GetVpcLinksPaginated, request)
          def createResource(request: CreateResourceRequest): IO[
            AwsError,
            zio.aws.apigateway.model.CreateResourceResponse.ReadOnly
          ] = proxy(CreateResource, request)
          def deleteDocumentationVersion(
              request: DeleteDocumentationVersionRequest
          ): IO[AwsError, Unit] = proxy(DeleteDocumentationVersion, request)
          def testInvokeAuthorizer(request: TestInvokeAuthorizerRequest): IO[
            AwsError,
            zio.aws.apigateway.model.TestInvokeAuthorizerResponse.ReadOnly
          ] = proxy(TestInvokeAuthorizer, request)
          def getRequestValidators(request: GetRequestValidatorsRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetRequestValidatorsResponse.ReadOnly
          ] = proxy(GetRequestValidators, request)
          def getDocumentationPart(request: GetDocumentationPartRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetDocumentationPartResponse.ReadOnly
          ] = proxy(GetDocumentationPart, request)
          def updateResource(request: UpdateResourceRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateResourceResponse.ReadOnly
          ] = proxy(UpdateResource, request)
          def deleteRestApi(request: DeleteRestApiRequest): IO[AwsError, Unit] =
            proxy(DeleteRestApi, request)
          def getMethod(
              request: GetMethodRequest
          ): IO[AwsError, zio.aws.apigateway.model.GetMethodResponse.ReadOnly] =
            proxy(GetMethod, request)
          def deleteUsagePlan(
              request: DeleteUsagePlanRequest
          ): IO[AwsError, Unit] = proxy(DeleteUsagePlan, request)
          def getDomainNames(request: GetDomainNamesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigateway.model.DomainName.ReadOnly
          ] = rts.unsafeRun(proxy(GetDomainNames, request))
          def getDomainNamesPaginated(request: GetDomainNamesRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetDomainNamesResponse.ReadOnly
          ] = proxy(GetDomainNamesPaginated, request)
          def createBasePathMapping(request: CreateBasePathMappingRequest): IO[
            AwsError,
            zio.aws.apigateway.model.CreateBasePathMappingResponse.ReadOnly
          ] = proxy(CreateBasePathMapping, request)
          def updateBasePathMapping(request: UpdateBasePathMappingRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateBasePathMappingResponse.ReadOnly
          ] = proxy(UpdateBasePathMapping, request)
          def createModel(request: CreateModelRequest): IO[
            AwsError,
            zio.aws.apigateway.model.CreateModelResponse.ReadOnly
          ] = proxy(CreateModel, request)
          def getMethodResponse(request: GetMethodResponseRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetMethodResponseResponse.ReadOnly
          ] = proxy(GetMethodResponse, request)
          def getClientCertificates(
              request: GetClientCertificatesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.apigateway.model.ClientCertificate.ReadOnly
          ] = rts.unsafeRun(proxy(GetClientCertificates, request))
          def getClientCertificatesPaginated(
              request: GetClientCertificatesRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.GetClientCertificatesResponse.ReadOnly
          ] = proxy(GetClientCertificatesPaginated, request)
          def createUsagePlan(request: CreateUsagePlanRequest): IO[
            AwsError,
            zio.aws.apigateway.model.CreateUsagePlanResponse.ReadOnly
          ] = proxy(CreateUsagePlan, request)
          def updateApiKey(request: UpdateApiKeyRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateApiKeyResponse.ReadOnly
          ] = proxy(UpdateApiKey, request)
          def updateModel(request: UpdateModelRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateModelResponse.ReadOnly
          ] = proxy(UpdateModel, request)
          def createDocumentationPart(
              request: CreateDocumentationPartRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.CreateDocumentationPartResponse.ReadOnly
          ] = proxy(CreateDocumentationPart, request)
          def getDocumentationParts(request: GetDocumentationPartsRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetDocumentationPartsResponse.ReadOnly
          ] = proxy(GetDocumentationParts, request)
          def deleteVpcLink(request: DeleteVpcLinkRequest): IO[AwsError, Unit] =
            proxy(DeleteVpcLink, request)
          def getVpcLink(request: GetVpcLinkRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetVpcLinkResponse.ReadOnly
          ] = proxy(GetVpcLink, request)
          def createRequestValidator(
              request: CreateRequestValidatorRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.CreateRequestValidatorResponse.ReadOnly
          ] = proxy(CreateRequestValidator, request)
          def testInvokeMethod(request: TestInvokeMethodRequest): IO[
            AwsError,
            zio.aws.apigateway.model.TestInvokeMethodResponse.ReadOnly
          ] = proxy(TestInvokeMethod, request)
          def deleteUsagePlanKey(
              request: DeleteUsagePlanKeyRequest
          ): IO[AwsError, Unit] = proxy(DeleteUsagePlanKey, request)
          def putIntegrationResponse(
              request: PutIntegrationResponseRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.PutIntegrationResponseResponse.ReadOnly
          ] = proxy(PutIntegrationResponse, request)
          def getDeployment(request: GetDeploymentRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetDeploymentResponse.ReadOnly
          ] = proxy(GetDeployment, request)
          def deleteDeployment(
              request: DeleteDeploymentRequest
          ): IO[AwsError, Unit] = proxy(DeleteDeployment, request)
          def flushStageCache(
              request: FlushStageCacheRequest
          ): IO[AwsError, Unit] = proxy(FlushStageCache, request)
          def getStage(
              request: GetStageRequest
          ): IO[AwsError, zio.aws.apigateway.model.GetStageResponse.ReadOnly] =
            proxy(GetStage, request)
          def deleteIntegration(
              request: DeleteIntegrationRequest
          ): IO[AwsError, Unit] = proxy(DeleteIntegration, request)
          def updateDeployment(request: UpdateDeploymentRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateDeploymentResponse.ReadOnly
          ] = proxy(UpdateDeployment, request)
          def getIntegrationResponse(
              request: GetIntegrationResponseRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.GetIntegrationResponseResponse.ReadOnly
          ] = proxy(GetIntegrationResponse, request)
          def deleteMethodResponse(
              request: DeleteMethodResponseRequest
          ): IO[AwsError, Unit] = proxy(DeleteMethodResponse, request)
          def getGatewayResponses(request: GetGatewayResponsesRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetGatewayResponsesResponse.ReadOnly
          ] = proxy(GetGatewayResponses, request)
          def getAccount(request: GetAccountRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetAccountResponse.ReadOnly
          ] = proxy(GetAccount, request)
          def updateVpcLink(request: UpdateVpcLinkRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateVpcLinkResponse.ReadOnly
          ] = proxy(UpdateVpcLink, request)
          def getUsage(
              request: GetUsageRequest
          ): IO[AwsError, zio.aws.apigateway.model.GetUsageResponse.ReadOnly] =
            proxy(GetUsage, request)
          def getSdkType(request: GetSdkTypeRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetSdkTypeResponse.ReadOnly
          ] = proxy(GetSdkType, request)
          def getExport(
              request: GetExportRequest
          ): IO[AwsError, zio.aws.apigateway.model.GetExportResponse.ReadOnly] =
            proxy(GetExport, request)
          def getModel(
              request: GetModelRequest
          ): IO[AwsError, zio.aws.apigateway.model.GetModelResponse.ReadOnly] =
            proxy(GetModel, request)
          def createRestApi(request: CreateRestApiRequest): IO[
            AwsError,
            zio.aws.apigateway.model.CreateRestApiResponse.ReadOnly
          ] = proxy(CreateRestApi, request)
          def deleteDocumentationPart(
              request: DeleteDocumentationPartRequest
          ): IO[AwsError, Unit] = proxy(DeleteDocumentationPart, request)
          def updateAuthorizer(request: UpdateAuthorizerRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateAuthorizerResponse.ReadOnly
          ] = proxy(UpdateAuthorizer, request)
          def putMethodResponse(request: PutMethodResponseRequest): IO[
            AwsError,
            zio.aws.apigateway.model.PutMethodResponseResponse.ReadOnly
          ] = proxy(PutMethodResponse, request)
          def createDocumentationVersion(
              request: CreateDocumentationVersionRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.CreateDocumentationVersionResponse.ReadOnly
          ] = proxy(CreateDocumentationVersion, request)
          def deleteStage(request: DeleteStageRequest): IO[AwsError, Unit] =
            proxy(DeleteStage, request)
          def flushStageAuthorizersCache(
              request: FlushStageAuthorizersCacheRequest
          ): IO[AwsError, Unit] = proxy(FlushStageAuthorizersCache, request)
          def getApiKeys(
              request: GetApiKeysRequest
          ): ZStream[Any, AwsError, ReadOnly] =
            rts.unsafeRun(proxy(GetApiKeys, request))
          def getApiKeysPaginated(request: GetApiKeysRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetApiKeysResponse.ReadOnly
          ] = proxy(GetApiKeysPaginated, request)
          def updateUsage(request: UpdateUsageRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateUsageResponse.ReadOnly
          ] = proxy(UpdateUsage, request)
          def deleteModel(request: DeleteModelRequest): IO[AwsError, Unit] =
            proxy(DeleteModel, request)
          def deleteMethod(request: DeleteMethodRequest): IO[AwsError, Unit] =
            proxy(DeleteMethod, request)
          def getClientCertificate(request: GetClientCertificateRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetClientCertificateResponse.ReadOnly
          ] = proxy(GetClientCertificate, request)
          def getRestApis(
              request: GetRestApisRequest
          ): ZStream[Any, AwsError, zio.aws.apigateway.model.RestApi.ReadOnly] =
            rts.unsafeRun(proxy(GetRestApis, request))
          def getRestApisPaginated(request: GetRestApisRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetRestApisResponse.ReadOnly
          ] = proxy(GetRestApisPaginated, request)
          def createDomainName(request: CreateDomainNameRequest): IO[
            AwsError,
            zio.aws.apigateway.model.CreateDomainNameResponse.ReadOnly
          ] = proxy(CreateDomainName, request)
          def getResources(request: GetResourcesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigateway.model.Resource.ReadOnly
          ] = rts.unsafeRun(proxy(GetResources, request))
          def getResourcesPaginated(request: GetResourcesRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetResourcesResponse.ReadOnly
          ] = proxy(GetResourcesPaginated, request)
          def getDocumentationVersion(
              request: GetDocumentationVersionRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.GetDocumentationVersionResponse.ReadOnly
          ] = proxy(GetDocumentationVersion, request)
          def updateClientCertificate(
              request: UpdateClientCertificateRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateClientCertificateResponse.ReadOnly
          ] = proxy(UpdateClientCertificate, request)
          def importApiKeys(request: ImportApiKeysRequest): IO[
            AwsError,
            zio.aws.apigateway.model.ImportApiKeysResponse.ReadOnly
          ] = proxy(ImportApiKeys, request)
          def createVpcLink(request: CreateVpcLinkRequest): IO[
            AwsError,
            zio.aws.apigateway.model.CreateVpcLinkResponse.ReadOnly
          ] = proxy(CreateVpcLink, request)
          def getApiKey(
              request: GetApiKeyRequest
          ): IO[AwsError, zio.aws.apigateway.model.GetApiKeyResponse.ReadOnly] =
            proxy(GetApiKey, request)
          def deleteClientCertificate(
              request: DeleteClientCertificateRequest
          ): IO[AwsError, Unit] = proxy(DeleteClientCertificate, request)
          def updateRestApi(request: UpdateRestApiRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateRestApiResponse.ReadOnly
          ] = proxy(UpdateRestApi, request)
          def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
            proxy(UntagResource, request)
          def getAuthorizers(request: GetAuthorizersRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetAuthorizersResponse.ReadOnly
          ] = proxy(GetAuthorizers, request)
          def updateIntegrationResponse(
              request: UpdateIntegrationResponseRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateIntegrationResponseResponse.ReadOnly
          ] = proxy(UpdateIntegrationResponse, request)
          def deleteApiKey(request: DeleteApiKeyRequest): IO[AwsError, Unit] =
            proxy(DeleteApiKey, request)
          def createDeployment(request: CreateDeploymentRequest): IO[
            AwsError,
            zio.aws.apigateway.model.CreateDeploymentResponse.ReadOnly
          ] = proxy(CreateDeployment, request)
          def updateDocumentationPart(
              request: UpdateDocumentationPartRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateDocumentationPartResponse.ReadOnly
          ] = proxy(UpdateDocumentationPart, request)
          def createApiKey(request: CreateApiKeyRequest): IO[
            AwsError,
            zio.aws.apigateway.model.CreateApiKeyResponse.ReadOnly
          ] = proxy(CreateApiKey, request)
          def putIntegration(request: PutIntegrationRequest): IO[
            AwsError,
            zio.aws.apigateway.model.PutIntegrationResponse.ReadOnly
          ] = proxy(PutIntegration, request)
          def importDocumentationParts(
              request: ImportDocumentationPartsRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.ImportDocumentationPartsResponse.ReadOnly
          ] = proxy(ImportDocumentationParts, request)
          def getModelTemplate(request: GetModelTemplateRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetModelTemplateResponse.ReadOnly
          ] = proxy(GetModelTemplate, request)
          def createStage(request: CreateStageRequest): IO[
            AwsError,
            zio.aws.apigateway.model.CreateStageResponse.ReadOnly
          ] = proxy(CreateStage, request)
          def getUsagePlanKey(request: GetUsagePlanKeyRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetUsagePlanKeyResponse.ReadOnly
          ] = proxy(GetUsagePlanKey, request)
          def updateMethodResponse(request: UpdateMethodResponseRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateMethodResponseResponse.ReadOnly
          ] = proxy(UpdateMethodResponse, request)
          def getRestApi(request: GetRestApiRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetRestApiResponse.ReadOnly
          ] = proxy(GetRestApi, request)
          def createAuthorizer(request: CreateAuthorizerRequest): IO[
            AwsError,
            zio.aws.apigateway.model.CreateAuthorizerResponse.ReadOnly
          ] = proxy(CreateAuthorizer, request)
          def putMethod(
              request: PutMethodRequest
          ): IO[AwsError, zio.aws.apigateway.model.PutMethodResponse.ReadOnly] =
            proxy(PutMethod, request)
          def getGatewayResponse(request: GetGatewayResponseRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetGatewayResponseResponse.ReadOnly
          ] = proxy(GetGatewayResponse, request)
          def generateClientCertificate(
              request: GenerateClientCertificateRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.GenerateClientCertificateResponse.ReadOnly
          ] = proxy(GenerateClientCertificate, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
            proxy(TagResource, request)
          def getUsagePlan(request: GetUsagePlanRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetUsagePlanResponse.ReadOnly
          ] = proxy(GetUsagePlan, request)
          def createUsagePlanKey(request: CreateUsagePlanKeyRequest): IO[
            AwsError,
            zio.aws.apigateway.model.CreateUsagePlanKeyResponse.ReadOnly
          ] = proxy(CreateUsagePlanKey, request)
          def updateUsagePlan(request: UpdateUsagePlanRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateUsagePlanResponse.ReadOnly
          ] = proxy(UpdateUsagePlan, request)
          def getIntegration(request: GetIntegrationRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetIntegrationResponse.ReadOnly
          ] = proxy(GetIntegration, request)
          def getDeployments(request: GetDeploymentsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigateway.model.Deployment.ReadOnly
          ] = rts.unsafeRun(proxy(GetDeployments, request))
          def getDeploymentsPaginated(request: GetDeploymentsRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetDeploymentsResponse.ReadOnly
          ] = proxy(GetDeploymentsPaginated, request)
          def putRestApi(request: PutRestApiRequest): IO[
            AwsError,
            zio.aws.apigateway.model.PutRestApiResponse.ReadOnly
          ] = proxy(PutRestApi, request)
          def getUsagePlans(request: GetUsagePlansRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigateway.model.UsagePlan.ReadOnly
          ] = rts.unsafeRun(proxy(GetUsagePlans, request))
          def getUsagePlansPaginated(request: GetUsagePlansRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetUsagePlansResponse.ReadOnly
          ] = proxy(GetUsagePlansPaginated, request)
          def getSdk(
              request: GetSdkRequest
          ): IO[AwsError, zio.aws.apigateway.model.GetSdkResponse.ReadOnly] =
            proxy(GetSdk, request)
          def deleteAuthorizer(
              request: DeleteAuthorizerRequest
          ): IO[AwsError, Unit] = proxy(DeleteAuthorizer, request)
          def getBasePathMapping(request: GetBasePathMappingRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetBasePathMappingResponse.ReadOnly
          ] = proxy(GetBasePathMapping, request)
          def deleteRequestValidator(
              request: DeleteRequestValidatorRequest
          ): IO[AwsError, Unit] = proxy(DeleteRequestValidator, request)
          def getSdkTypes(request: GetSdkTypesRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetSdkTypesResponse.ReadOnly
          ] = proxy(GetSdkTypes, request)
          def getUsagePlanKeys(request: GetUsagePlanKeysRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigateway.model.UsagePlanKey.ReadOnly
          ] = rts.unsafeRun(proxy(GetUsagePlanKeys, request))
          def getUsagePlanKeysPaginated(request: GetUsagePlanKeysRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetUsagePlanKeysResponse.ReadOnly
          ] = proxy(GetUsagePlanKeysPaginated, request)
          def deleteIntegrationResponse(
              request: DeleteIntegrationResponseRequest
          ): IO[AwsError, Unit] = proxy(DeleteIntegrationResponse, request)
          def updateMethod(request: UpdateMethodRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateMethodResponse.ReadOnly
          ] = proxy(UpdateMethod, request)
          def updateIntegration(request: UpdateIntegrationRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateIntegrationResponse.ReadOnly
          ] = proxy(UpdateIntegration, request)
          def importRestApi(request: ImportRestApiRequest): IO[
            AwsError,
            zio.aws.apigateway.model.ImportRestApiResponse.ReadOnly
          ] = proxy(ImportRestApi, request)
          def deleteGatewayResponse(
              request: DeleteGatewayResponseRequest
          ): IO[AwsError, Unit] = proxy(DeleteGatewayResponse, request)
          def updateGatewayResponse(request: UpdateGatewayResponseRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateGatewayResponseResponse.ReadOnly
          ] = proxy(UpdateGatewayResponse, request)
          def updateDocumentationVersion(
              request: UpdateDocumentationVersionRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateDocumentationVersionResponse.ReadOnly
          ] = proxy(UpdateDocumentationVersion, request)
          def putGatewayResponse(request: PutGatewayResponseRequest): IO[
            AwsError,
            zio.aws.apigateway.model.PutGatewayResponseResponse.ReadOnly
          ] = proxy(PutGatewayResponse, request)
          def getRequestValidator(request: GetRequestValidatorRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetRequestValidatorResponse.ReadOnly
          ] = proxy(GetRequestValidator, request)
          def getModels(
              request: GetModelsRequest
          ): ZStream[Any, AwsError, zio.aws.apigateway.model.Model.ReadOnly] =
            rts.unsafeRun(proxy(GetModels, request))
          def getModelsPaginated(
              request: GetModelsRequest
          ): IO[AwsError, zio.aws.apigateway.model.GetModelsResponse.ReadOnly] =
            proxy(GetModelsPaginated, request)
          def getStages(
              request: GetStagesRequest
          ): IO[AwsError, zio.aws.apigateway.model.GetStagesResponse.ReadOnly] =
            proxy(GetStages, request)
          def getDomainName(request: GetDomainNameRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetDomainNameResponse.ReadOnly
          ] = proxy(GetDomainName, request)
          def getDocumentationVersions(
              request: GetDocumentationVersionsRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.GetDocumentationVersionsResponse.ReadOnly
          ] = proxy(GetDocumentationVersions, request)
          def getAuthorizer(request: GetAuthorizerRequest): IO[
            AwsError,
            zio.aws.apigateway.model.GetAuthorizerResponse.ReadOnly
          ] = proxy(GetAuthorizer, request)
          def deleteDomainName(
              request: DeleteDomainNameRequest
          ): IO[AwsError, Unit] = proxy(DeleteDomainName, request)
          def updateRequestValidator(
              request: UpdateRequestValidatorRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateRequestValidatorResponse.ReadOnly
          ] = proxy(UpdateRequestValidator, request)
          def getBasePathMappings(request: GetBasePathMappingsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigateway.model.BasePathMapping.ReadOnly
          ] = rts.unsafeRun(proxy(GetBasePathMappings, request))
          def getBasePathMappingsPaginated(
              request: GetBasePathMappingsRequest
          ): IO[
            AwsError,
            zio.aws.apigateway.model.GetBasePathMappingsResponse.ReadOnly
          ] = proxy(GetBasePathMappingsPaginated, request)
          def deleteBasePathMapping(
              request: DeleteBasePathMappingRequest
          ): IO[AwsError, Unit] = proxy(DeleteBasePathMapping, request)
          def updateDomainName(request: UpdateDomainNameRequest): IO[
            AwsError,
            zio.aws.apigateway.model.UpdateDomainNameResponse.ReadOnly
          ] = proxy(UpdateDomainName, request)
          def deleteResource(
              request: DeleteResourceRequest
          ): IO[AwsError, Unit] = proxy(DeleteResource, request)
          def getTags(
              request: GetTagsRequest
          ): IO[AwsError, zio.aws.apigateway.model.GetTagsResponse.ReadOnly] =
            proxy(GetTags, request)
        }
      }
    }
    .toLayer
}
