package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AccessLogSettings(
    format: Option[String] = None,
    destinationArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.AccessLogSettings = {
    import AccessLogSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.AccessLogSettings
      .builder()
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(destinationArn.map(value => value: java.lang.String))(
        _.destinationArn
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.AccessLogSettings.ReadOnly =
    zio.aws.apigateway.model.AccessLogSettings.wrap(buildAwsValue())
}
object AccessLogSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.AccessLogSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.AccessLogSettings =
      zio.aws.apigateway.model.AccessLogSettings(
        format.map(value => value),
        destinationArn.map(value => value)
      )
    def format: Option[String]
    def destinationArn: Option[String]
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getDestinationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.AccessLogSettings
  ) extends zio.aws.apigateway.model.AccessLogSettings.ReadOnly {
    override val format: Option[String] =
      scala.Option(impl.format()).map(value => value: String)
    override val destinationArn: Option[String] =
      scala.Option(impl.destinationArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.AccessLogSettings
  ): zio.aws.apigateway.model.AccessLogSettings.ReadOnly = new Wrapper(impl)
}
