package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CanarySettings(
    percentTraffic: Option[Double] = None,
    deploymentId: Option[String] = None,
    stageVariableOverrides: Option[Map[String, String]] = None,
    useStageCache: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CanarySettings = {
    import CanarySettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CanarySettings
      .builder()
      .optionallyWith(percentTraffic.map(value => value: java.lang.Double))(
        _.percentTraffic
      )
      .optionallyWith(deploymentId.map(value => value: java.lang.String))(
        _.deploymentId
      )
      .optionallyWith(
        stageVariableOverrides.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.stageVariableOverrides)
      .optionallyWith(useStageCache.map(value => value: java.lang.Boolean))(
        _.useStageCache
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CanarySettings.ReadOnly =
    zio.aws.apigateway.model.CanarySettings.wrap(buildAwsValue())
}
object CanarySettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CanarySettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CanarySettings =
      zio.aws.apigateway.model.CanarySettings(
        percentTraffic.map(value => value),
        deploymentId.map(value => value),
        stageVariableOverrides.map(value => value),
        useStageCache.map(value => value)
      )
    def percentTraffic: Option[Double]
    def deploymentId: Option[String]
    def stageVariableOverrides: Option[Map[String, String]]
    def useStageCache: Option[Boolean]
    def getPercentTraffic: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("percentTraffic", percentTraffic)
    def getDeploymentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getStageVariableOverrides: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField(
        "stageVariableOverrides",
        stageVariableOverrides
      )
    def getUseStageCache: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useStageCache", useStageCache)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CanarySettings
  ) extends zio.aws.apigateway.model.CanarySettings.ReadOnly {
    override val percentTraffic: Option[Double] =
      scala.Option(impl.percentTraffic()).map(value => value: Double)
    override val deploymentId: Option[String] =
      scala.Option(impl.deploymentId()).map(value => value: String)
    override val stageVariableOverrides: Option[Map[String, String]] = scala
      .Option(impl.stageVariableOverrides())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val useStageCache: Option[Boolean] =
      scala.Option(impl.useStageCache()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CanarySettings
  ): zio.aws.apigateway.model.CanarySettings.ReadOnly = new Wrapper(impl)
}
