package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateResourceRequest(
    restApiId: String,
    parentId: String,
    pathPart: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateResourceRequest = {
    import CreateResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateResourceRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .parentId(parentId: java.lang.String)
      .pathPart(pathPart: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateResourceRequest.ReadOnly =
    zio.aws.apigateway.model.CreateResourceRequest.wrap(buildAwsValue())
}
object CreateResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateResourceRequest =
      zio.aws.apigateway.model
        .CreateResourceRequest(restApiId, parentId, pathPart)
    def restApiId: String
    def parentId: String
    def pathPart: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getParentId: ZIO[Any, Nothing, String] = ZIO.succeed(parentId)
    def getPathPart: ZIO[Any, Nothing, String] = ZIO.succeed(pathPart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateResourceRequest
  ) extends zio.aws.apigateway.model.CreateResourceRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val parentId: String = impl.parentId(): String
    override val pathPart: String = impl.pathPart(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateResourceRequest
  ): zio.aws.apigateway.model.CreateResourceRequest.ReadOnly = new Wrapper(impl)
}
