package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateStageRequest(
    restApiId: String,
    stageName: String,
    deploymentId: String,
    description: Option[String] = None,
    cacheClusterEnabled: Option[Boolean] = None,
    cacheClusterSize: Option[String] = None,
    variables: Option[Map[String, String]] = None,
    documentationVersion: Option[String] = None,
    canarySettings: Option[zio.aws.apigateway.model.CanarySettings] = None,
    tracingEnabled: Option[Boolean] = None,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateStageRequest = {
    import CreateStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateStageRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .stageName(stageName: java.lang.String)
      .deploymentId(deploymentId: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        cacheClusterEnabled.map(value => value: java.lang.Boolean)
      )(_.cacheClusterEnabled)
      .optionallyWith(cacheClusterSize.map(value => value: java.lang.String))(
        _.cacheClusterSize
      )
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.variables)
      .optionallyWith(
        documentationVersion.map(value => value: java.lang.String)
      )(_.documentationVersion)
      .optionallyWith(canarySettings.map(value => value.buildAwsValue()))(
        _.canarySettings
      )
      .optionallyWith(tracingEnabled.map(value => value: java.lang.Boolean))(
        _.tracingEnabled
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateStageRequest.ReadOnly =
    zio.aws.apigateway.model.CreateStageRequest.wrap(buildAwsValue())
}
object CreateStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateStageRequest =
      zio.aws.apigateway.model.CreateStageRequest(
        restApiId,
        stageName,
        deploymentId,
        description.map(value => value),
        cacheClusterEnabled.map(value => value),
        cacheClusterSize.map(value => value),
        variables.map(value => value),
        documentationVersion.map(value => value),
        canarySettings.map(value => value.asEditable),
        tracingEnabled.map(value => value),
        tags.map(value => value)
      )
    def restApiId: String
    def stageName: String
    def deploymentId: String
    def description: Option[String]
    def cacheClusterEnabled: Option[Boolean]
    def cacheClusterSize: Option[String]
    def variables: Option[Map[String, String]]
    def documentationVersion: Option[String]
    def canarySettings: Option[zio.aws.apigateway.model.CanarySettings.ReadOnly]
    def tracingEnabled: Option[Boolean]
    def tags: Option[Map[String, String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getStageName: ZIO[Any, Nothing, String] = ZIO.succeed(stageName)
    def getDeploymentId: ZIO[Any, Nothing, String] = ZIO.succeed(deploymentId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getCacheClusterEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cacheClusterEnabled", cacheClusterEnabled)
    def getCacheClusterSize: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterSize", cacheClusterSize)
    def getVariables: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("variables", variables)
    def getDocumentationVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("documentationVersion", documentationVersion)
    def getCanarySettings
        : ZIO[Any, AwsError, zio.aws.apigateway.model.CanarySettings.ReadOnly] =
      AwsError.unwrapOptionField("canarySettings", canarySettings)
    def getTracingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("tracingEnabled", tracingEnabled)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateStageRequest
  ) extends zio.aws.apigateway.model.CreateStageRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val stageName: String = impl.stageName(): String
    override val deploymentId: String = impl.deploymentId(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val cacheClusterEnabled: Option[Boolean] =
      scala.Option(impl.cacheClusterEnabled()).map(value => value: Boolean)
    override val cacheClusterSize: Option[String] =
      scala.Option(impl.cacheClusterSize()).map(value => value: String)
    override val variables: Option[Map[String, String]] = scala
      .Option(impl.variables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val documentationVersion: Option[String] =
      scala.Option(impl.documentationVersion()).map(value => value: String)
    override val canarySettings
        : Option[zio.aws.apigateway.model.CanarySettings.ReadOnly] = scala
      .Option(impl.canarySettings())
      .map(value => zio.aws.apigateway.model.CanarySettings.wrap(value))
    override val tracingEnabled: Option[Boolean] =
      scala.Option(impl.tracingEnabled()).map(value => value: Boolean)
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateStageRequest
  ): zio.aws.apigateway.model.CreateStageRequest.ReadOnly = new Wrapper(impl)
}
