package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateUsagePlanRequest(
    name: String,
    description: Option[String] = None,
    apiStages: Option[Iterable[zio.aws.apigateway.model.ApiStage]] = None,
    throttle: Option[zio.aws.apigateway.model.ThrottleSettings] = None,
    quota: Option[zio.aws.apigateway.model.QuotaSettings] = None,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateUsagePlanRequest = {
    import CreateUsagePlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateUsagePlanRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        apiStages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.apiStages)
      .optionallyWith(throttle.map(value => value.buildAwsValue()))(_.throttle)
      .optionallyWith(quota.map(value => value.buildAwsValue()))(_.quota)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateUsagePlanRequest.ReadOnly =
    zio.aws.apigateway.model.CreateUsagePlanRequest.wrap(buildAwsValue())
}
object CreateUsagePlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateUsagePlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateUsagePlanRequest =
      zio.aws.apigateway.model.CreateUsagePlanRequest(
        name,
        description.map(value => value),
        apiStages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        throttle.map(value => value.asEditable),
        quota.map(value => value.asEditable),
        tags.map(value => value)
      )
    def name: String
    def description: Option[String]
    def apiStages: Option[List[zio.aws.apigateway.model.ApiStage.ReadOnly]]
    def throttle: Option[zio.aws.apigateway.model.ThrottleSettings.ReadOnly]
    def quota: Option[zio.aws.apigateway.model.QuotaSettings.ReadOnly]
    def tags: Option[Map[String, String]]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getApiStages
        : ZIO[Any, AwsError, List[zio.aws.apigateway.model.ApiStage.ReadOnly]] =
      AwsError.unwrapOptionField("apiStages", apiStages)
    def getThrottle: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.ThrottleSettings.ReadOnly
    ] = AwsError.unwrapOptionField("throttle", throttle)
    def getQuota
        : ZIO[Any, AwsError, zio.aws.apigateway.model.QuotaSettings.ReadOnly] =
      AwsError.unwrapOptionField("quota", quota)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateUsagePlanRequest
  ) extends zio.aws.apigateway.model.CreateUsagePlanRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val apiStages
        : Option[List[zio.aws.apigateway.model.ApiStage.ReadOnly]] = scala
      .Option(impl.apiStages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.ApiStage.wrap(item)
        }.toList
      )
    override val throttle
        : Option[zio.aws.apigateway.model.ThrottleSettings.ReadOnly] = scala
      .Option(impl.throttle())
      .map(value => zio.aws.apigateway.model.ThrottleSettings.wrap(value))
    override val quota
        : Option[zio.aws.apigateway.model.QuotaSettings.ReadOnly] = scala
      .Option(impl.quota())
      .map(value => zio.aws.apigateway.model.QuotaSettings.wrap(value))
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateUsagePlanRequest
  ): zio.aws.apigateway.model.CreateUsagePlanRequest.ReadOnly = new Wrapper(
    impl
  )
}
