package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateVpcLinkRequest(
    name: String,
    description: Option[String] = None,
    targetArns: Iterable[String],
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateVpcLinkRequest = {
    import CreateVpcLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateVpcLinkRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .targetArns(targetArns.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateVpcLinkRequest.ReadOnly =
    zio.aws.apigateway.model.CreateVpcLinkRequest.wrap(buildAwsValue())
}
object CreateVpcLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateVpcLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateVpcLinkRequest =
      zio.aws.apigateway.model.CreateVpcLinkRequest(
        name,
        description.map(value => value),
        targetArns,
        tags.map(value => value)
      )
    def name: String
    def description: Option[String]
    def targetArns: List[String]
    def tags: Option[Map[String, String]]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTargetArns: ZIO[Any, Nothing, List[String]] = ZIO.succeed(targetArns)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateVpcLinkRequest
  ) extends zio.aws.apigateway.model.CreateVpcLinkRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val targetArns: List[String] = impl
      .targetArns()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateVpcLinkRequest
  ): zio.aws.apigateway.model.CreateVpcLinkRequest.ReadOnly = new Wrapper(impl)
}
