package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteBasePathMappingRequest(
    domainName: String,
    basePath: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingRequest = {
    import DeleteBasePathMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .basePath(basePath: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.DeleteBasePathMappingRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteBasePathMappingRequest.wrap(buildAwsValue())
}
object DeleteBasePathMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteBasePathMappingRequest =
      zio.aws.apigateway.model
        .DeleteBasePathMappingRequest(domainName, basePath)
    def domainName: String
    def basePath: String
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getBasePath: ZIO[Any, Nothing, String] = ZIO.succeed(basePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingRequest
  ) extends zio.aws.apigateway.model.DeleteBasePathMappingRequest.ReadOnly {
    override val domainName: String = impl.domainName(): String
    override val basePath: String = impl.basePath(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingRequest
  ): zio.aws.apigateway.model.DeleteBasePathMappingRequest.ReadOnly =
    new Wrapper(impl)
}
