package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteUsagePlanKeyRequest(usagePlanId: String, keyId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyRequest = {
    import DeleteUsagePlanKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyRequest
      .builder()
      .usagePlanId(usagePlanId: java.lang.String)
      .keyId(keyId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeleteUsagePlanKeyRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteUsagePlanKeyRequest.wrap(buildAwsValue())
}
object DeleteUsagePlanKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteUsagePlanKeyRequest =
      zio.aws.apigateway.model.DeleteUsagePlanKeyRequest(usagePlanId, keyId)
    def usagePlanId: String
    def keyId: String
    def getUsagePlanId: ZIO[Any, Nothing, String] = ZIO.succeed(usagePlanId)
    def getKeyId: ZIO[Any, Nothing, String] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyRequest
  ) extends zio.aws.apigateway.model.DeleteUsagePlanKeyRequest.ReadOnly {
    override val usagePlanId: String = impl.usagePlanId(): String
    override val keyId: String = impl.keyId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyRequest
  ): zio.aws.apigateway.model.DeleteUsagePlanKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
