package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeploymentCanarySettings(
    percentTraffic: Option[Double] = None,
    stageVariableOverrides: Option[Map[String, String]] = None,
    useStageCache: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeploymentCanarySettings = {
    import DeploymentCanarySettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeploymentCanarySettings
      .builder()
      .optionallyWith(percentTraffic.map(value => value: java.lang.Double))(
        _.percentTraffic
      )
      .optionallyWith(
        stageVariableOverrides.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.stageVariableOverrides)
      .optionallyWith(useStageCache.map(value => value: java.lang.Boolean))(
        _.useStageCache
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeploymentCanarySettings.ReadOnly =
    zio.aws.apigateway.model.DeploymentCanarySettings.wrap(buildAwsValue())
}
object DeploymentCanarySettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeploymentCanarySettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeploymentCanarySettings =
      zio.aws.apigateway.model.DeploymentCanarySettings(
        percentTraffic.map(value => value),
        stageVariableOverrides.map(value => value),
        useStageCache.map(value => value)
      )
    def percentTraffic: Option[Double]
    def stageVariableOverrides: Option[Map[String, String]]
    def useStageCache: Option[Boolean]
    def getPercentTraffic: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("percentTraffic", percentTraffic)
    def getStageVariableOverrides: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField(
        "stageVariableOverrides",
        stageVariableOverrides
      )
    def getUseStageCache: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useStageCache", useStageCache)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeploymentCanarySettings
  ) extends zio.aws.apigateway.model.DeploymentCanarySettings.ReadOnly {
    override val percentTraffic: Option[Double] =
      scala.Option(impl.percentTraffic()).map(value => value: Double)
    override val stageVariableOverrides: Option[Map[String, String]] = scala
      .Option(impl.stageVariableOverrides())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val useStageCache: Option[Boolean] =
      scala.Option(impl.useStageCache()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeploymentCanarySettings
  ): zio.aws.apigateway.model.DeploymentCanarySettings.ReadOnly = new Wrapper(
    impl
  )
}
