package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FlushStageAuthorizersCacheRequest(
    restApiId: String,
    stageName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheRequest = {
    import FlushStageAuthorizersCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .stageName(stageName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.FlushStageAuthorizersCacheRequest.ReadOnly =
    zio.aws.apigateway.model.FlushStageAuthorizersCacheRequest
      .wrap(buildAwsValue())
}
object FlushStageAuthorizersCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.FlushStageAuthorizersCacheRequest =
      zio.aws.apigateway.model
        .FlushStageAuthorizersCacheRequest(restApiId, stageName)
    def restApiId: String
    def stageName: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getStageName: ZIO[Any, Nothing, String] = ZIO.succeed(stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheRequest
  ) extends zio.aws.apigateway.model.FlushStageAuthorizersCacheRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val stageName: String = impl.stageName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheRequest
  ): zio.aws.apigateway.model.FlushStageAuthorizersCacheRequest.ReadOnly =
    new Wrapper(impl)
}
