package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableBoolean
import scala.jdk.CollectionConverters.*
final case class GetApiKeyRequest(
    apiKey: String,
    includeValue: Option[NullableBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest = {
    import GetApiKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest
      .builder()
      .apiKey(apiKey: java.lang.String)
      .optionallyWith(
        includeValue.map(value =>
          NullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.includeValue)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetApiKeyRequest.ReadOnly =
    zio.aws.apigateway.model.GetApiKeyRequest.wrap(buildAwsValue())
}
object GetApiKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetApiKeyRequest =
      zio.aws.apigateway.model
        .GetApiKeyRequest(apiKey, includeValue.map(value => value))
    def apiKey: String
    def includeValue: Option[NullableBoolean]
    def getApiKey: ZIO[Any, Nothing, String] = ZIO.succeed(apiKey)
    def getIncludeValue: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("includeValue", includeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest
  ) extends zio.aws.apigateway.model.GetApiKeyRequest.ReadOnly {
    override val apiKey: String = impl.apiKey(): String
    override val includeValue: Option[NullableBoolean] = scala
      .Option(impl.includeValue())
      .map(value => zio.aws.apigateway.model.primitives.NullableBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest
  ): zio.aws.apigateway.model.GetApiKeyRequest.ReadOnly = new Wrapper(impl)
}
