package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableInteger
import scala.jdk.CollectionConverters.*
final case class GetAuthorizersRequest(
    restApiId: String,
    position: Option[String] = None,
    limit: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest = {
    import GetAuthorizersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        limit.map(value => NullableInteger.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetAuthorizersRequest.ReadOnly =
    zio.aws.apigateway.model.GetAuthorizersRequest.wrap(buildAwsValue())
}
object GetAuthorizersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetAuthorizersRequest =
      zio.aws.apigateway.model.GetAuthorizersRequest(
        restApiId,
        position.map(value => value),
        limit.map(value => value)
      )
    def restApiId: String
    def position: Option[String]
    def limit: Option[NullableInteger]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest
  ) extends zio.aws.apigateway.model.GetAuthorizersRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val limit: Option[NullableInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.apigateway.model.primitives.NullableInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest
  ): zio.aws.apigateway.model.GetAuthorizersRequest.ReadOnly = new Wrapper(impl)
}
