package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAuthorizersResponse(
    position: Option[String] = None,
    items: Option[Iterable[zio.aws.apigateway.model.Authorizer]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetAuthorizersResponse = {
    import GetAuthorizersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetAuthorizersResponse
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetAuthorizersResponse.ReadOnly =
    zio.aws.apigateway.model.GetAuthorizersResponse.wrap(buildAwsValue())
}
object GetAuthorizersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetAuthorizersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetAuthorizersResponse =
      zio.aws.apigateway.model.GetAuthorizersResponse(
        position.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def position: Option[String]
    def items: Option[List[zio.aws.apigateway.model.Authorizer.ReadOnly]]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.Authorizer.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetAuthorizersResponse
  ) extends zio.aws.apigateway.model.GetAuthorizersResponse.ReadOnly {
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val items
        : Option[List[zio.aws.apigateway.model.Authorizer.ReadOnly]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.Authorizer.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetAuthorizersResponse
  ): zio.aws.apigateway.model.GetAuthorizersResponse.ReadOnly = new Wrapper(
    impl
  )
}
