package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableInteger
import scala.jdk.CollectionConverters.*
final case class GetDocumentationPartsRequest(
    restApiId: String,
    `type`: Option[zio.aws.apigateway.model.DocumentationPartType] = None,
    nameQuery: Option[String] = None,
    path: Option[String] = None,
    position: Option[String] = None,
    limit: Option[NullableInteger] = None,
    locationStatus: Option[zio.aws.apigateway.model.LocationStatusType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest = {
    import GetDocumentationPartsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(nameQuery.map(value => value: java.lang.String))(
        _.nameQuery
      )
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        limit.map(value => NullableInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(locationStatus.map(value => value.unwrap))(
        _.locationStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.GetDocumentationPartsRequest.ReadOnly =
    zio.aws.apigateway.model.GetDocumentationPartsRequest.wrap(buildAwsValue())
}
object GetDocumentationPartsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetDocumentationPartsRequest =
      zio.aws.apigateway.model.GetDocumentationPartsRequest(
        restApiId,
        `type`.map(value => value),
        nameQuery.map(value => value),
        path.map(value => value),
        position.map(value => value),
        limit.map(value => value),
        locationStatus.map(value => value)
      )
    def restApiId: String
    def `type`: Option[zio.aws.apigateway.model.DocumentationPartType]
    def nameQuery: Option[String]
    def path: Option[String]
    def position: Option[String]
    def limit: Option[NullableInteger]
    def locationStatus: Option[zio.aws.apigateway.model.LocationStatusType]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getType
        : ZIO[Any, AwsError, zio.aws.apigateway.model.DocumentationPartType] =
      AwsError.unwrapOptionField("type", `type`)
    def getNameQuery: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nameQuery", nameQuery)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getLocationStatus
        : ZIO[Any, AwsError, zio.aws.apigateway.model.LocationStatusType] =
      AwsError.unwrapOptionField("locationStatus", locationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest
  ) extends zio.aws.apigateway.model.GetDocumentationPartsRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val `type`
        : Option[zio.aws.apigateway.model.DocumentationPartType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.apigateway.model.DocumentationPartType.wrap(value))
    override val nameQuery: Option[String] =
      scala.Option(impl.nameQuery()).map(value => value: String)
    override val path: Option[String] =
      scala.Option(impl.path()).map(value => value: String)
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val limit: Option[NullableInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.apigateway.model.primitives.NullableInteger(value))
    override val locationStatus
        : Option[zio.aws.apigateway.model.LocationStatusType] = scala
      .Option(impl.locationStatus())
      .map(value => zio.aws.apigateway.model.LocationStatusType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest
  ): zio.aws.apigateway.model.GetDocumentationPartsRequest.ReadOnly =
    new Wrapper(impl)
}
