package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.apigateway.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class GetDocumentationVersionResponse(
    version: Option[String] = None,
    createdDate: Option[Timestamp] = None,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionResponse = {
    import GetDocumentationVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionResponse
      .builder()
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.GetDocumentationVersionResponse.ReadOnly =
    zio.aws.apigateway.model.GetDocumentationVersionResponse
      .wrap(buildAwsValue())
}
object GetDocumentationVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetDocumentationVersionResponse =
      zio.aws.apigateway.model.GetDocumentationVersionResponse(
        version.map(value => value),
        createdDate.map(value => value),
        description.map(value => value)
      )
    def version: Option[String]
    def createdDate: Option[Timestamp]
    def description: Option[String]
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionResponse
  ) extends zio.aws.apigateway.model.GetDocumentationVersionResponse.ReadOnly {
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override val createdDate: Option[Timestamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionResponse
  ): zio.aws.apigateway.model.GetDocumentationVersionResponse.ReadOnly =
    new Wrapper(impl)
}
