package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDomainNamesResponse(
    position: Option[String] = None,
    items: Option[Iterable[zio.aws.apigateway.model.DomainName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse = {
    import GetDomainNamesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetDomainNamesResponse.ReadOnly =
    zio.aws.apigateway.model.GetDomainNamesResponse.wrap(buildAwsValue())
}
object GetDomainNamesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetDomainNamesResponse =
      zio.aws.apigateway.model.GetDomainNamesResponse(
        position.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def position: Option[String]
    def items: Option[List[zio.aws.apigateway.model.DomainName.ReadOnly]]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.DomainName.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse
  ) extends zio.aws.apigateway.model.GetDomainNamesResponse.ReadOnly {
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val items
        : Option[List[zio.aws.apigateway.model.DomainName.ReadOnly]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.DomainName.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse
  ): zio.aws.apigateway.model.GetDomainNamesResponse.ReadOnly = new Wrapper(
    impl
  )
}
