package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetModelRequest(
    restApiId: String,
    modelName: String,
    flatten: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetModelRequest = {
    import GetModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetModelRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .modelName(modelName: java.lang.String)
      .optionallyWith(flatten.map(value => value: java.lang.Boolean))(_.flatten)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetModelRequest.ReadOnly =
    zio.aws.apigateway.model.GetModelRequest.wrap(buildAwsValue())
}
object GetModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetModelRequest =
      zio.aws.apigateway.model
        .GetModelRequest(restApiId, modelName, flatten.map(value => value))
    def restApiId: String
    def modelName: String
    def flatten: Option[Boolean]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getModelName: ZIO[Any, Nothing, String] = ZIO.succeed(modelName)
    def getFlatten: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("flatten", flatten)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetModelRequest
  ) extends zio.aws.apigateway.model.GetModelRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val modelName: String = impl.modelName(): String
    override val flatten: Option[Boolean] =
      scala.Option(impl.flatten()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetModelRequest
  ): zio.aws.apigateway.model.GetModelRequest.ReadOnly = new Wrapper(impl)
}
