package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRequestValidatorRequest(
    restApiId: String,
    requestValidatorId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetRequestValidatorRequest = {
    import GetRequestValidatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetRequestValidatorRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .requestValidatorId(requestValidatorId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetRequestValidatorRequest.ReadOnly =
    zio.aws.apigateway.model.GetRequestValidatorRequest.wrap(buildAwsValue())
}
object GetRequestValidatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetRequestValidatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetRequestValidatorRequest =
      zio.aws.apigateway.model
        .GetRequestValidatorRequest(restApiId, requestValidatorId)
    def restApiId: String
    def requestValidatorId: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getRequestValidatorId: ZIO[Any, Nothing, String] =
      ZIO.succeed(requestValidatorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetRequestValidatorRequest
  ) extends zio.aws.apigateway.model.GetRequestValidatorRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val requestValidatorId: String = impl.requestValidatorId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetRequestValidatorRequest
  ): zio.aws.apigateway.model.GetRequestValidatorRequest.ReadOnly = new Wrapper(
    impl
  )
}
