package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetResourceRequest(
    restApiId: String,
    resourceId: String,
    embed: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetResourceRequest = {
    import GetResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetResourceRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .optionallyWith(
        embed.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.embed)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetResourceRequest.ReadOnly =
    zio.aws.apigateway.model.GetResourceRequest.wrap(buildAwsValue())
}
object GetResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetResourceRequest =
      zio.aws.apigateway.model
        .GetResourceRequest(restApiId, resourceId, embed.map(value => value))
    def restApiId: String
    def resourceId: String
    def embed: Option[List[String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getEmbed: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("embed", embed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetResourceRequest
  ) extends zio.aws.apigateway.model.GetResourceRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val embed: Option[List[String]] = scala
      .Option(impl.embed())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetResourceRequest
  ): zio.aws.apigateway.model.GetResourceRequest.ReadOnly = new Wrapper(impl)
}
