package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.Blob
import scala.jdk.CollectionConverters.*
final case class GetSdkResponse(
    contentType: Option[String] = None,
    contentDisposition: Option[String] = None,
    body: Option[Blob] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetSdkResponse = {
    import GetSdkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetSdkResponse
      .builder()
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .optionallyWith(contentDisposition.map(value => value: java.lang.String))(
        _.contentDisposition
      )
      .optionallyWith(
        body.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.body)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetSdkResponse.ReadOnly =
    zio.aws.apigateway.model.GetSdkResponse.wrap(buildAwsValue())
}
object GetSdkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetSdkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetSdkResponse =
      zio.aws.apigateway.model.GetSdkResponse(
        contentType.map(value => value),
        contentDisposition.map(value => value),
        body.map(value => value)
      )
    def contentType: Option[String]
    def contentDisposition: Option[String]
    def body: Option[Blob]
    def getContentType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getContentDisposition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentDisposition", contentDisposition)
    def getBody: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("body", body)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetSdkResponse
  ) extends zio.aws.apigateway.model.GetSdkResponse.ReadOnly {
    override val contentType: Option[String] =
      scala.Option(impl.contentType()).map(value => value: String)
    override val contentDisposition: Option[String] =
      scala.Option(impl.contentDisposition()).map(value => value: String)
    override val body: Option[Blob] = scala
      .Option(impl.body())
      .map(value =>
        zio.aws.apigateway.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetSdkResponse
  ): zio.aws.apigateway.model.GetSdkResponse.ReadOnly = new Wrapper(impl)
}
