package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetStagesRequest(
    restApiId: String,
    deploymentId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetStagesRequest = {
    import GetStagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetStagesRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .optionallyWith(deploymentId.map(value => value: java.lang.String))(
        _.deploymentId
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetStagesRequest.ReadOnly =
    zio.aws.apigateway.model.GetStagesRequest.wrap(buildAwsValue())
}
object GetStagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetStagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetStagesRequest =
      zio.aws.apigateway.model
        .GetStagesRequest(restApiId, deploymentId.map(value => value))
    def restApiId: String
    def deploymentId: Option[String]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getDeploymentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetStagesRequest
  ) extends zio.aws.apigateway.model.GetStagesRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val deploymentId: Option[String] =
      scala.Option(impl.deploymentId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetStagesRequest
  ): zio.aws.apigateway.model.GetStagesRequest.ReadOnly = new Wrapper(impl)
}
